/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.pmap;

import ca.odell.glazedlists.impl.nio.NIODaemon;
import ca.odell.glazedlists.impl.pmap.AddChunk;
import ca.odell.glazedlists.impl.pmap.Chunk;
import ca.odell.glazedlists.impl.pmap.CloseFile;
import ca.odell.glazedlists.impl.pmap.NoOp;
import ca.odell.glazedlists.impl.pmap.OpenFile;
import ca.odell.glazedlists.impl.pmap.RemoveChunk;
import ca.odell.glazedlists.io.ByteCoder;
import ca.odell.glazedlists.io.GlazedListsIO;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PersistentMap
implements Map {
    private static Logger logger = Logger.getLogger(PersistentMap.class.toString());
    private static final String FILE_ACCESS_MODE = "rwd";
    private File file = null;
    private FileChannel fileChannel = null;
    private NIODaemon nioDaemon = null;
    private Map map = new HashMap();
    private ByteCoder keyCoder = null;
    private int nextSequenceId = 1500;
    private int nextAvailableByte = 8;

    public PersistentMap(File file) throws IOException {
        this(file, GlazedListsIO.serializableByteCoder());
    }

    public PersistentMap(File file, ByteCoder keyCoder) throws IOException {
        this.file = file;
        this.keyCoder = keyCoder;
        this.fileChannel = new RandomAccessFile(file, FILE_ACCESS_MODE).getChannel();
        this.nioDaemon = new NIODaemon();
        this.nioDaemon.start();
        this.nioDaemon.invokeAndWait(new OpenFile(this));
    }

    public void close() {
        this.nioDaemon.invokeAndWait(new CloseFile(this));
        this.map = null;
    }

    public void flush() {
        this.nioDaemon.invokeAndWait(NoOp.instance());
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        if (!(value instanceof Chunk)) {
            throw new IllegalArgumentException("value must be a chunk");
        }
        Chunk newValue = (Chunk)value;
        newValue.initializeForPersistence(this, key);
        Chunk oldValue = this.map.put(key, newValue);
        this.nioDaemon.invokeLater(new AddChunk(this, newValue, oldValue));
        return oldValue;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object remove(Object key) {
        Chunk removed = (Chunk)this.map.remove(key);
        if (removed == null) {
            return null;
        }
        this.nioDaemon.invokeLater(new RemoveChunk(this, removed));
        return removed;
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void putAll(Map m3) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.map.size();
    }

    int nextSequenceId() {
        return this.nextSequenceId++;
    }

    NIODaemon getNIODaemon() {
        return this.nioDaemon;
    }

    File getFile() {
        return this.file;
    }

    FileChannel getFileChannel() {
        return this.fileChannel;
    }

    void fail(IOException e, String message) {
        logger.log(Level.SEVERE, message, e);
    }

    void loadedChunk(Chunk chunk) {
        if (chunk.isOn()) {
            this.map.put(chunk.getKey(), chunk);
            this.nextSequenceId = Math.max(this.nextSequenceId, chunk.getSequenceId() + 1);
        }
        this.nextAvailableByte = Math.max(this.nextAvailableByte, chunk.getOffset() + chunk.size());
    }

    ByteCoder getKeyCoder() {
        return this.keyCoder;
    }

    void allocate(Chunk value) throws IOException {
        int offset = this.nextAvailableByte;
        int size = value.bytesRequired();
        this.nextAvailableByte += size;
        value.allocateAsNew(offset, size);
    }
}

