/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGPreparedStatement;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGCallableStatement
extends PGPreparedStatement
implements CallableStatement {
    String fullSqlText;
    List<ParameterMode> allParameterModes;
    List<String> outParameterNames;
    List<Type> outParameterTypes;
    Map<Integer, Integer> outParameterSQLTypes;
    List<Object> outParameterValues;
    Map<String, Class<?>> typeMap;
    Boolean nullFlag;
    private static final Map<Integer, Pattern> PARAM_REPLACE_REGEXES = new ConcurrentHashMap<Integer, Pattern>();
    private static final Pattern CLEANUP_LEADING_COMMAS_REGEX = Pattern.compile("\\(\\s*,+");
    private static final Pattern CLEANUP_MIDDLE_COMMAS_REGEX = Pattern.compile(",\\s*,");
    private static final Pattern CLEANUP_TAILING_COMMAS_REGEX = Pattern.compile(",+\\s*\\)");

    PGCallableStatement(PGConnectionImpl connection, int type, int concurrency, int holdability, String name, String sqlText, int parameterCount, String cursorName, boolean hasAssign) throws SQLException {
        super(connection, type, concurrency, holdability, name, sqlText, 0, cursorName);
        this.typeMap = connection.getTypeMap();
        this.fullSqlText = sqlText;
        this.allParameterModes = new ArrayList<ParameterMode>(Collections.nCopies(parameterCount, null));
        this.outParameterNames = new ArrayList<String>();
        this.outParameterTypes = new ArrayList<Type>();
        this.outParameterSQLTypes = new HashMap<Integer, Integer>();
        this.outParameterValues = new ArrayList<Object>();
        if (hasAssign) {
            this.allParameterModes.add(0, ParameterMode.Assign);
        }
    }

    @Override
    void verifyParameterSet() throws SQLException {
    }

    @Override
    void parseIfNeeded() throws SQLException {
        this.sqlText = this.fullSqlText;
        int reSeq = 1;
        for (int c = 0; c < this.allParameterModes.size(); ++c) {
            Matcher matcher = PGCallableStatement.getRegexForParameter(c + 1).matcher(this.sqlText);
            this.sqlText = this.allParameterModes.get(c) == ParameterMode.Out ? matcher.replaceFirst("$2") : matcher.replaceFirst("\\$" + reSeq++ + "$2");
        }
        this.sqlText = CLEANUP_LEADING_COMMAS_REGEX.matcher(this.sqlText).replaceAll("(");
        this.sqlText = CLEANUP_MIDDLE_COMMAS_REGEX.matcher(this.sqlText).replaceAll(",");
        this.sqlText = CLEANUP_TAILING_COMMAS_REGEX.matcher(this.sqlText).replaceAll(")");
        super.parseIfNeeded();
    }

    private static Pattern getRegexForParameter(int paramIndex) {
        Pattern pattern = PARAM_REPLACE_REGEXES.get(paramIndex);
        if (pattern == null) {
            pattern = Pattern.compile("\\s*\\$(" + paramIndex + ")\\s*([,)])");
            PARAM_REPLACE_REGEXES.put(paramIndex, pattern);
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() throws SQLException {
        boolean res = super.execute();
        if (this.outParameterTypes.isEmpty()) return res;
        if (this.resultBatches.isEmpty()) throw new SQLException("out parameters not returned");
        QueryCommand.ResultBatch returnValuesBatch = (QueryCommand.ResultBatch)this.resultBatches.remove(0);
        try {
            if (returnValuesBatch.getFields().size() != this.outParameterTypes.size()) {
                throw new SQLException("incorrect number of out parameters");
            }
            if (returnValuesBatch.getResults() == null || returnValuesBatch.getResults().isEmpty()) return res;
            DataRow returnValues = returnValuesBatch.getResults().get(0);
            for (int c = 0; c < this.outParameterValues.size(); ++c) {
                Object value;
                ResultField field2 = returnValuesBatch.getFields().get(c);
                try {
                    value = returnValues.getColumn(c);
                }
                catch (IOException e) {
                    throw new PGSQLSimpleException("Error decoding column", e);
                }
                this.outParameterNames.set(c, field2.getName());
                this.outParameterTypes.set(c, field2.getTypeRef().get());
                this.outParameterValues.set(c, value);
            }
            return res;
        }
        finally {
            returnValuesBatch.release();
        }
    }

    int mapToInParameterIndex(int parameterIdx) {
        int inParameterIdx = parameterIdx;
        for (int allParameterIdx = 1; allParameterIdx < this.allParameterModes.size() && allParameterIdx <= parameterIdx; ++allParameterIdx) {
            ParameterMode mode = this.allParameterModes.get(allParameterIdx - 1);
            if (mode != ParameterMode.Out && mode != ParameterMode.Assign) continue;
            --inParameterIdx;
        }
        return inParameterIdx;
    }

    int mapToOutParameterIndex(int parameterIdx) throws SQLException {
        if (this.allParameterModes.get(parameterIdx - 1) == ParameterMode.In) {
            throw new SQLException("parameter not available");
        }
        int outParameterIdx = parameterIdx;
        for (int allParameterIdx = 1; allParameterIdx < this.allParameterModes.size() && allParameterIdx <= parameterIdx; ++allParameterIdx) {
            ParameterMode mode = this.allParameterModes.get(allParameterIdx - 1);
            if (mode != ParameterMode.In && mode != null) continue;
            --outParameterIdx;
        }
        return outParameterIdx;
    }

    int mapFromOutParameterIndex(int outParameterIdx) {
        int parameterIdx = 0;
        for (int allParameterIdx = 1; allParameterIdx < this.allParameterModes.size() && allParameterIdx <= outParameterIdx; ++allParameterIdx) {
            if (this.allParameterModes.get(allParameterIdx - 1) != ParameterMode.In) continue;
            ++parameterIdx;
        }
        return parameterIdx;
    }

    Type getOutType(int parameterIdx) throws SQLException {
        if (parameterIdx < 1 || parameterIdx > this.outParameterValues.size()) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
        return this.outParameterTypes.get(parameterIdx - 1);
    }

    Object get(int parameterIdx) throws SQLException {
        Object val;
        if (parameterIdx < 1 || parameterIdx > this.outParameterValues.size()) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
        if (this.command == null) {
            throw new SQLException("statement not executed");
        }
        this.nullFlag = (val = this.outParameterValues.get(--parameterIdx)) == null;
        return val;
    }

    @Override
    void set(int parameterIdx, Object val, int targetSQLType) throws SQLException {
        ParameterMode mode = this.allParameterModes.get(parameterIdx - 1);
        if (mode == ParameterMode.Out) {
            this.allParameterModes.set(parameterIdx - 1, ParameterMode.InOut);
        } else if (mode == null) {
            this.allParameterModes.set(parameterIdx - 1, ParameterMode.In);
        }
        parameterIdx = this.mapToInParameterIndex(parameterIdx);
        int needed = parameterIdx > this.parameterValues.size() ? parameterIdx - this.parameterValues.size() : 0;
        this.parameterTypes.addAll(Collections.nCopies(needed, null));
        this.parameterValues.addAll(Collections.nCopies(needed, null));
        super.set(parameterIdx, val, targetSQLType);
    }

    int findParameter(String parameterName) throws SQLException {
        int idx = this.outParameterNames.indexOf(parameterName);
        if (idx == -1) {
            return -1;
        }
        return this.mapFromOutParameterIndex(idx);
    }

    @Override
    boolean allowBatchSelects() {
        return true;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        ParameterMode mode = this.allParameterModes.get(parameterIndex - 1);
        if (mode == ParameterMode.In) {
            this.allParameterModes.set(parameterIndex - 1, ParameterMode.InOut);
        } else if (mode == null) {
            this.allParameterModes.set(parameterIndex - 1, ParameterMode.Out);
        }
        int outParameterIdx = this.mapToOutParameterIndex(parameterIndex);
        int needed = outParameterIdx > this.outParameterValues.size() ? outParameterIdx - this.outParameterValues.size() : 0;
        this.outParameterNames.addAll(Collections.nCopies(needed, null));
        this.outParameterTypes.addAll(Collections.nCopies(needed, null));
        this.outParameterValues.addAll(Collections.nCopies(needed, null));
        this.outParameterSQLTypes.put(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameter(parameterName), sqlType, typeName);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        if (this.nullFlag == null) {
            throw new SQLException("no column fetched");
        }
        return this.nullFlag;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToString(this.get(parameterIndex), this.getOutType(parameterIndex), this.connection);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToBoolean(this.get(parameterIndex));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToByte(this.get(parameterIndex));
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToShort(this.get(parameterIndex));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToInt(this.get(parameterIndex));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToLong(this.get(parameterIndex));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToFloat(this.get(parameterIndex));
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        return SQLTypeUtils.coerceToDouble(this.get(parameterIndex));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        parameterIndex = this.mapToOutParameterIndex(parameterIndex);
        BigDecimal val = SQLTypeUtils.coerceToBigDecimal(parameterIndex);
        if (val == null) {
            return null;
        }
        return val.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        return SQLTypeUtils.coerceToBigDecimal(this.get(parameterIndex));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        try (InputStream data = SQLTypeUtils.coerceToByteStream(this.get(parameterIndex), this.getOutType(parameterIndex), this.connection);){
            if (data == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = ByteStreams.toByteArray(data);
            return byArray;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, Calendar.getInstance());
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, Calendar.getInstance());
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        TimeZone zone = cal.getTimeZone();
        return SQLTypeUtils.coerceToDate(this.get(parameterIndex), zone, this.connection);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        TimeZone zone = cal.getTimeZone();
        return SQLTypeUtils.coerceToTime(this.get(parameterIndex), zone, this.connection);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        TimeZone zone = cal.getTimeZone();
        return SQLTypeUtils.coerceToTimestamp(this.get(parameterIndex), zone, this.connection);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        this.checkClosed();
        Object value = this.get(parameterIndex);
        if (value == null) {
            return null;
        }
        Type type = this.getOutType(parameterIndex);
        if (!(type instanceof ArrayType)) {
            throw SQLTypeUtils.createCoercionException(value.getClass(), Array.class);
        }
        return new PGArray(this.connection, (ArrayType)type, (Object[])value);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        this.checkClosed();
        return SQLTypeUtils.coerceToURL(this.get(parameterIndex));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        String data = this.getString(parameterIndex);
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkClosed();
        return SQLTypeUtils.coerceToBlob(this.get(parameterIndex), this.connection);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkClosed();
        return SQLTypeUtils.coerceToClob(this.get(parameterIndex), this.connection);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        return SQLTypeUtils.coerceToXML(this.get(parameterIndex), this.connection);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.getObject(parameterIndex, this.typeMap);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        Type type = this.getOutType(parameterIndex);
        Class<Object> targetType = SQLTypeUtils.mapGetType(type, map, this.connection);
        if (this.connection.isStrictMode()) {
            Integer sqlType;
            if (InputStream.class.equals(targetType)) {
                targetType = byte[].class;
            } else if (Double.class.equals(targetType) && (sqlType = this.outParameterSQLTypes.get(parameterIndex)) != null && 7 == sqlType) {
                targetType = Float.class;
            }
        }
        return SQLTypeUtils.coerce(this.get(parameterIndex), type, targetType, map, this.connection);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        return type.cast(SQLTypeUtils.coerce(this.get(parameterIndex), this.getOutType(parameterIndex), type, this.typeMap, this.connection));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        this.checkClosed();
        return SQLTypeUtils.coerceToRowId(this.get(parameterIndex), this.getOutType(parameterIndex));
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameter(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameter(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameter(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameter(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameter(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameter(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameter(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameter(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameter(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameter(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameter(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameter(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameter(parameterName));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameter(parameterName));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findParameter(parameterName));
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameter(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameter(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameter(parameterName));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameter(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameter(parameterName));
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameter(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameter(parameterName));
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameter(parameterName));
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getRowId(this.findParameter(parameterName));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.findParameter(parameterName));
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getSQLXML(this.findParameter(parameterName));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findParameter(parameterName));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findParameter(parameterName));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findParameter(parameterName));
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findParameter(parameterName), type);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameter(parameterName), sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameter(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameter(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameter(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameter(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameter(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameter(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameter(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameter(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameter(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameter(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameter(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameter(parameterName), x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameter(parameterName), x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameter(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameter(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.set(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameter(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameter(parameterName), x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParameter(parameterName), sqlType, typeName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setRowId(this.findParameter(parameterName), x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setNString(this.findParameter(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(this.findParameter(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setNClob(this.findParameter(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.findParameter(parameterName), inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setNClob(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParameter(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.findParameter(parameterName), x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setSQLXML(this.findParameter(parameterName), xmlObject);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.findParameter(parameterName), val);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName), x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.findParameter(parameterName), reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.findParameter(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.findParameter(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.findParameter(parameterName), reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setNCharacterStream(this.findParameter(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.findParameter(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.findParameter(parameterName), inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setNClob(this.findParameter(parameterName), reader);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    static enum ParameterMode {
        In,
        Out,
        InOut,
        Assign;

    }
}

