/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.SQLTypeMetaData;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.CompositeType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

class PGResultSetMetaData
implements ResultSetMetaData {
    PGConnectionImpl connection;
    List<ResultField> resultFields;
    Map<String, Class<?>> typeMap;

    PGResultSetMetaData(PGConnectionImpl connection, List<ResultField> resultFields, Map<String, Class<?>> typeMap) {
        this.connection = connection;
        this.resultFields = resultFields;
        this.typeMap = typeMap;
    }

    ResultField get(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.resultFields.size()) {
            throw Exceptions.COLUMN_INDEX_OUT_OF_BOUNDS;
        }
        return this.resultFields.get(columnIndex - 1);
    }

    CompositeType getRelType(int columnIndex) throws SQLException {
        ResultField field2 = this.get(columnIndex);
        if (field2.getRelationId() == 0) {
            return null;
        }
        return this.connection.getRegistry().loadRelationType(field2.getRelationId());
    }

    CompositeType.Attribute getRelAttr(int columnIndex) throws SQLException {
        ResultField field2 = this.get(columnIndex);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field2.getRelationId());
        if (relType == null) {
            return null;
        }
        return relType.getAttribute(field2.getRelationAttributeNumber());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultFields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        ResultField field2 = this.get(column);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field2.getRelationId());
        return SQLTypeMetaData.isAutoIncrement(field2.getTypeRef().get(), relType, field2.getRelationAttributeNumber());
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return SQLTypeMetaData.isCaseSensitive(this.get(column).getTypeRef().get());
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return SQLTypeMetaData.isCurrency(this.get(column).getTypeRef().get());
    }

    @Override
    public int isNullable(int column) throws SQLException {
        ResultField field2 = this.get(column);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field2.getRelationId());
        return SQLTypeMetaData.isNullable(field2.getTypeRef().get(), relType, field2.getRelationAttributeNumber());
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return SQLTypeMetaData.isSigned(this.get(column).getTypeRef().get());
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        String val = this.get(column).getName();
        if (val == null) {
            val = this.getColumnName(column);
        }
        return val;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.connection.getSetting("database").toString();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        CompositeType relType = this.getRelType(column);
        if (relType == null) {
            return "";
        }
        return relType.getNamespace();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        CompositeType relType = this.getRelType(column);
        if (relType == null) {
            return "";
        }
        return relType.getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String val;
        if (this.connection.isStrictMode() && (val = this.get(column).getName()) != null) {
            return val;
        }
        CompositeType.Attribute attr = this.getRelAttr(column);
        if (attr == null) {
            return this.get(column).getName();
        }
        return attr.getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ResultField field2 = this.get(column);
        return SQLTypeMetaData.getSQLType(field2.getTypeRef().get());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ResultField field2 = this.get(column);
        CompositeType relType = this.connection.getRegistry().loadRelationType(field2.getRelationId());
        return SQLTypeMetaData.getTypeName(field2.getTypeRef().get(), relType, field2.getRelationAttributeNumber());
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ResultField field2 = this.get(column);
        return SQLTypeUtils.mapGetType(field2.getTypeRef().get(), this.typeMap, this.connection).getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ResultField field2 = this.get(column);
        return SQLTypeMetaData.getPrecision(field2.getTypeRef().get(), field2.getTypeLength(), field2.getTypeModifier());
    }

    @Override
    public int getScale(int column) throws SQLException {
        ResultField field2 = this.get(column);
        return SQLTypeMetaData.getScale(field2.getTypeRef().get(), field2.getTypeLength(), field2.getTypeModifier());
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        ResultField field2 = this.get(column);
        return SQLTypeMetaData.getDisplaySize(field2.getTypeRef().get(), field2.getTypeLength(), field2.getTypeModifier());
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.get(column).getRelationAttributeNumber() == 0;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }
}

