/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.datetime.instants.AmbiguousInstant;
import com.impossibl.postgres.datetime.instants.FutureInfiniteInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.Instants;
import com.impossibl.postgres.datetime.instants.PastInfiniteInstant;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class Dates
extends SimpleProcProvider {
    private static final long PG_EPOCH_SECS = 946684800L;
    static final long DAY_SECS = TimeUnit.DAYS.toSeconds(1L);
    static final long CUTOFF_1_START_SECS = -13165977600L;
    static final long CUTOFF_1_END_SECS = -12219292800L;
    static final long CUTOFF_2_START_SECS = -15773356800L;
    static final long CUTOFF_2_END_SECS = -14825808000L;
    static final long APPROX_YEAR_SECS1 = -3155823050L;
    static final long APPROX_YEAR_SECS2 = 3155760000L;

    public Dates() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "date_");
    }

    private static int toPgDays(Instant a) {
        long secs = TimeUnit.MICROSECONDS.toSeconds(a.getMicrosLocal());
        if ((secs -= 946684800L) < -13165977600L && (secs -= DAY_SECS * 10L) < -15773356800L) {
            int years = (int)((secs - -15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            secs += (long)years * DAY_SECS;
        }
        return (int)Math.floor((double)secs / (double)DAY_SECS);
    }

    private static long toJavaMicros(long days) {
        long secs = TimeUnit.DAYS.toSeconds(days);
        if ((secs += 946684800L) < -12219292800L && (secs += DAY_SECS * 10L) < -14825808000L) {
            int extraLeaps = (int)((secs - -14825808000L) / 3155760000L);
            --extraLeaps;
            extraLeaps -= extraLeaps / 4;
            secs += (long)extraLeaps * DAY_SECS;
        }
        return TimeUnit.SECONDS.toMicros(secs);
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Date;
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        protected void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            String strVal = context.getDateFormatter().getPrinter().format((Instant)val);
            buffer.append(strVal);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Date;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        protected Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            HashMap<String, Object> pieces = new HashMap<String, Object>();
            context.getDateFormatter().getParser().parse(buffer.toString(), 0, pieces);
            return Instants.dateFromPieces(pieces, context.getTimeZone()).ambiguate();
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Instant.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Date;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                Instant inst = (Instant)val;
                int daysPg = inst.getType() == Instant.Type.Infinity ? (inst.getMicrosLocal() < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE) : Dates.toPgDays(inst);
                buffer.writeInt(4);
                buffer.writeInt(daysPg);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Date;
        }

        @Override
        public Class<?> getOutputType() {
            return Instant.class;
        }

        @Override
        public Instant decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 4) {
                throw new IOException("invalid length");
            }
            int daysPg = buffer.readInt();
            if (daysPg == Integer.MAX_VALUE) {
                return FutureInfiniteInstant.INSTANCE;
            }
            if (daysPg == Integer.MIN_VALUE) {
                return PastInfiniteInstant.INSTANCE;
            }
            long micros = Dates.toJavaMicros(daysPg);
            return new AmbiguousInstant(Instant.Type.Date, micros);
        }
    }
}

