/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.http.impl.conn;

import com.microsoft.applicationinsights.core.dependencies.http.Consts;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.core.dependencies.http.impl.conn.Wire;
import com.microsoft.applicationinsights.core.dependencies.http.io.EofSensor;
import com.microsoft.applicationinsights.core.dependencies.http.io.HttpTransportMetrics;
import com.microsoft.applicationinsights.core.dependencies.http.io.SessionInputBuffer;
import com.microsoft.applicationinsights.core.dependencies.http.util.CharArrayBuffer;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LoggingSessionInputBuffer
implements SessionInputBuffer,
EofSensor {
    private final SessionInputBuffer in;
    private final EofSensor eofSensor;
    private final Wire wire;
    private final String charset;

    public LoggingSessionInputBuffer(SessionInputBuffer in, Wire wire, String charset) {
        this.in = in;
        this.eofSensor = in instanceof EofSensor ? (EofSensor)((Object)in) : null;
        this.wire = wire;
        this.charset = charset != null ? charset : Consts.ASCII.name();
    }

    public LoggingSessionInputBuffer(SessionInputBuffer in, Wire wire) {
        this(in, wire, null);
    }

    @Override
    public boolean isDataAvailable(int timeout) throws IOException {
        return this.in.isDataAvailable(timeout);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = this.in.read(b, off, len);
        if (this.wire.enabled() && l > 0) {
            this.wire.input(b, off, l);
        }
        return l;
    }

    @Override
    public int read() throws IOException {
        int l = this.in.read();
        if (this.wire.enabled() && l != -1) {
            this.wire.input(l);
        }
        return l;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int l = this.in.read(b);
        if (this.wire.enabled() && l > 0) {
            this.wire.input(b, 0, l);
        }
        return l;
    }

    @Override
    public String readLine() throws IOException {
        String s2 = this.in.readLine();
        if (this.wire.enabled() && s2 != null) {
            String tmp = s2 + "\r\n";
            this.wire.input(tmp.getBytes(this.charset));
        }
        return s2;
    }

    @Override
    public int readLine(CharArrayBuffer buffer) throws IOException {
        int l = this.in.readLine(buffer);
        if (this.wire.enabled() && l >= 0) {
            int pos = buffer.length() - l;
            String s2 = new String(buffer.buffer(), pos, l);
            String tmp = s2 + "\r\n";
            this.wire.input(tmp.getBytes(this.charset));
        }
        return l;
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.in.getMetrics();
    }

    @Override
    public boolean isEof() {
        if (this.eofSensor != null) {
            return this.eofSensor.isEof();
        }
        return false;
    }
}

