/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.config.ParamXmlElement;
import com.microsoft.applicationinsights.internal.config.ReflectionUtils;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorXmlElement;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;

public final class TelemetryProcessorCreator {
    public TelemetryProcessor Create(TelemetryProcessorXmlElement confClass) {
        if (confClass == null) {
            return null;
        }
        TelemetryProcessor processor = null;
        processor = ReflectionUtils.createInstance(confClass.getType(), TelemetryProcessor.class);
        if (processor == null) {
            return null;
        }
        try {
            if (confClass.getExcludedTypes() != null) {
                if (confClass.getExcludedTypes().getExcludedType() != null) {
                    for (String paramExcluded : confClass.getExcludedTypes().getExcludedType()) {
                        try {
                            if (ReflectionUtils.activateMethod(processor, "addToExcludedType", paramExcluded, String.class)) continue;
                            InternalLogger.INSTANCE.error("%s: method 'addToExcludedType' failed, the class will not be used.", confClass.getType());
                            return null;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            try {
                                InternalLogger.INSTANCE.error("%s: failed to activate method 'methodName', the class will not be used. Exception : %s", confClass.getType(), ExceptionUtils.getStackTrace(t));
                                return null;
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable td) {
                            }
                        }
                    }
                } else {
                    InternalLogger.INSTANCE.error("Empty list of Excluded Types", new Object[0]);
                }
            } else {
                InternalLogger.INSTANCE.info("Excluded types not specified falling back to default", new Object[0]);
            }
            if (confClass.getIncludedTypes() != null) {
                if (confClass.getIncludedTypes().getIncludedType() != null) {
                    for (String paramIncluded : confClass.getIncludedTypes().getIncludedType()) {
                        try {
                            if (ReflectionUtils.activateMethod(processor, "addToIncludedType", paramIncluded, String.class)) continue;
                            InternalLogger.INSTANCE.error("%s: method 'addToIncludeType' failed, the class will not be used.", confClass.getType());
                            return null;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            try {
                                InternalLogger.INSTANCE.error("%s: failed to activate method 'methodName', the class will not be used. Exception : %s", confClass.getType(), ExceptionUtils.getStackTrace(t));
                                return null;
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable td) {
                            }
                        }
                    }
                } else {
                    InternalLogger.INSTANCE.error("Empty list of Included Types", new Object[0]);
                }
            } else {
                InternalLogger.INSTANCE.info("Included types not specified falling back to default", new Object[0]);
            }
            for (ParamXmlElement param2 : confClass.getAdds()) {
                String methodName = "set" + param2.getName();
                try {
                    if (ReflectionUtils.activateMethod(processor, methodName, param2.getValue(), String.class)) continue;
                    InternalLogger.INSTANCE.error("%s: method %s failed, the class will not be used.", confClass.getType(), methodName);
                    return null;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        InternalLogger.INSTANCE.error("%s: failed to activate method %s,  the class will not be used. Exception : %s", confClass.getType(), methodName, ExceptionUtils.getStackTrace(t));
                        return null;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            try {
                InternalLogger.INSTANCE.error("%s: unexpected exception while creating processor %s, the class will not be used. Exception : %s", confClass.getType(), confClass.getType(), ExceptionUtils.getStackTrace(throwable));
                return null;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return processor;
    }
}

