/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.PerformanceCounterData;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;

public final class PerformanceCounterTelemetry
extends BaseTelemetry<PerformanceCounterData> {
    private final PerformanceCounterData data;
    private static final String ENVELOPE_NAME = "PerformanceCounter";
    private static final String BASE_TYPE = "PerformanceCounterData";

    public PerformanceCounterTelemetry() {
        this.data = new PerformanceCounterData();
        this.initialize(this.data.getProperties());
    }

    public PerformanceCounterTelemetry(String categoryName, String counterName, String instanceName, double value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(categoryName), "categoryName must be non null, non empty value");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(counterName), "counterName must be non null, non empty value");
        this.data = new PerformanceCounterData();
        this.initialize(this.data.getProperties());
        this.data.setCategoryName(categoryName);
        this.data.setCounterName(counterName);
        this.data.setInstanceName(instanceName);
        this.data.setValue(value);
    }

    public void setCategoryName(String categoryName) {
        this.data.setCategoryName(categoryName);
    }

    public String getCategoryName() {
        return this.data.getCategoryName();
    }

    public void setCounterName(String counterName) {
        this.data.setCounterName(counterName);
    }

    public String getCounterName() {
        return this.data.getCounterName();
    }

    public void setInstanceName(String instanceName) {
        this.data.setInstanceName(instanceName);
    }

    public String getInstanceName() {
        return this.data.getInstanceName();
    }

    public void setValue(double value) {
        this.data.setValue(value);
    }

    public double getValue() {
        return this.data.getValue();
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
    }

    @Override
    protected PerformanceCounterData getData() {
        return this.data;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }
}

