/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.zotero;

import de.undercouch.citeproc.CSLDateParser;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.ListItemDataProvider;
import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.helper.StringHelper;
import java.util.LinkedHashSet;
import java.util.Set;

public class ZoteroItemDataProvider
extends ListItemDataProvider {
    public ZoteroItemDataProvider(ItemDataProvider provider) {
        super(ZoteroItemDataProvider.sanitizeItems(provider));
    }

    private static CSLItemData[] sanitizeItems(ItemDataProvider provider) {
        LinkedHashSet<String> knownIds = new LinkedHashSet<String>();
        CSLDateParser dateParser = new CSLDateParser();
        String[] ids = provider.getIds();
        CSLItemData[] result = new CSLItemData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            CSLItemData item = provider.retrieveItem(id);
            String newId = ZoteroItemDataProvider.makeId(item, dateParser);
            newId = ZoteroItemDataProvider.uniquify(newId, knownIds);
            knownIds.add(newId);
            result[i] = item = new CSLItemDataBuilder(item).id(newId).build();
        }
        return result;
    }

    private static String makeId(CSLItemData item, CSLDateParser dateParser) {
        if (item.getAuthor() == null || item.getAuthor().length == 0) {
            return item.getId();
        }
        CSLName firstAuthor = item.getAuthor()[0];
        String a = firstAuthor.getFamily();
        if (!(a != null && !a.isEmpty() || (a = firstAuthor.getGiven()) != null && !a.isEmpty() || (a = firstAuthor.getLiteral()) != null && !a.isEmpty())) {
            return item.getId();
        }
        a = StringHelper.sanitize(a);
        int year = ZoteroItemDataProvider.getYear(item.getIssued(), dateParser);
        if (year < 0 && (year = ZoteroItemDataProvider.getYear(item.getContainer(), dateParser)) < 0 && (year = ZoteroItemDataProvider.getYear(item.getOriginalDate(), dateParser)) < 0 && (year = ZoteroItemDataProvider.getYear(item.getEventDate(), dateParser)) < 0) {
            year = ZoteroItemDataProvider.getYear(item.getSubmitted(), dateParser);
        }
        if (year >= 0) {
            a = a + year;
        }
        return a;
    }

    private static String uniquify(String id, Set<String> knownIds) {
        int n = 10;
        String olda = id;
        while (knownIds.contains(id)) {
            id = olda + Integer.toString(n, 36);
            ++n;
        }
        return id;
    }

    private static int getYear(CSLDate date, CSLDateParser dateParser) {
        if (date == null) {
            return -1;
        }
        if (date.getDateParts() == null || date.getDateParts().length == 0 || date.getDateParts()[0] == null || date.getDateParts()[0].length == 0) {
            if (date.getRaw() != null && !date.getRaw().isEmpty()) {
                CSLDate d = dateParser.parse(date.getRaw());
                return ZoteroItemDataProvider.getYear(d, dateParser);
            }
            return -1;
        }
        return date.getDateParts()[0][0];
    }
}

