/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.CharacterInsDelInterface;
import info.debatty.java.stringsimilarity.CharacterSubstitutionInterface;
import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import net.jcip.annotations.Immutable;

@Immutable
public class WeightedLevenshtein
implements StringDistance {
    private final CharacterSubstitutionInterface charsub;
    private final CharacterInsDelInterface charchange;

    public WeightedLevenshtein(CharacterSubstitutionInterface charsub) {
        this(charsub, null);
    }

    public WeightedLevenshtein(CharacterSubstitutionInterface charsub, CharacterInsDelInterface charchange) {
        this.charsub = charsub;
        this.charchange = charchange;
    }

    public final double distance(String s1, String s2) {
        int i;
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        double[] v0 = new double[s2.length() + 1];
        double[] v1 = new double[s2.length() + 1];
        v0[0] = 0.0;
        for (i = 1; i < v0.length; ++i) {
            v0[i] = v0[i - 1] + this.insertionCost(s2.charAt(i - 1));
        }
        for (i = 0; i < s1.length(); ++i) {
            char s1i = s1.charAt(i);
            double deletion_cost = this.deletionCost(s1i);
            v1[0] = v0[0] + deletion_cost;
            for (int j = 0; j < s2.length(); ++j) {
                char s2j = s2.charAt(j);
                double cost = 0.0;
                if (s1i != s2j) {
                    cost = this.charsub.cost(s1i, s2j);
                }
                double insertion_cost = this.insertionCost(s2j);
                v1[j + 1] = Math.min(v1[j] + insertion_cost, Math.min(v0[j + 1] + deletion_cost, v0[j] + cost));
            }
            double[] vtemp = v0;
            v0 = v1;
            v1 = vtemp;
        }
        return v0[s2.length()];
    }

    private double insertionCost(char c) {
        if (this.charchange == null) {
            return 1.0;
        }
        return this.charchange.insertionCost(c);
    }

    private double deletionCost(char c) {
        if (this.charchange == null) {
            return 1.0;
        }
        return this.charchange.deletionCost(c);
    }
}

