/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int count;

    public GlyfSimpleDescript(GlyfTable glyfTable, short n, ByteArrayInputStream byteArrayInputStream) {
        super(glyfTable, (short)n, byteArrayInputStream);
        int n2;
        this.endPtsOfContours = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.endPtsOfContours[n2] = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        }
        this.count = this.endPtsOfContours[n - 1] + 1;
        this.flags = new byte[this.count];
        this.xCoordinates = new short[this.count];
        this.yCoordinates = new short[this.count];
        n2 = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        this.readInstructions(byteArrayInputStream, n2);
        this.readFlags(this.count, byteArrayInputStream);
        this.readCoords(this.count, byteArrayInputStream);
    }

    @Override
    public int getEndPtOfContours(int n) {
        return this.endPtsOfContours[n];
    }

    @Override
    public byte getFlags(int n) {
        return this.flags[n];
    }

    @Override
    public short getXCoordinate(int n) {
        return this.xCoordinates[n];
    }

    @Override
    public short getYCoordinate(int n) {
        return this.yCoordinates[n];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this.count;
    }

    @Override
    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int n, ByteArrayInputStream byteArrayInputStream) {
        int n2;
        short s2 = 0;
        short s3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if ((this.flags[n2] & 0x10) != 0) {
                if ((this.flags[n2] & 2) != 0) {
                    s2 = (short)(s2 + (short)byteArrayInputStream.read());
                }
            } else {
                s2 = (this.flags[n2] & 2) != 0 ? (short)(s2 + (short)(-((short)byteArrayInputStream.read()))) : (short)(s2 + (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read()));
            }
            this.xCoordinates[n2] = s2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if ((this.flags[n2] & 0x20) != 0) {
                if ((this.flags[n2] & 4) != 0) {
                    s3 = (short)(s3 + (short)byteArrayInputStream.read());
                }
            } else {
                s3 = (this.flags[n2] & 4) != 0 ? (short)(s3 + (short)(-((short)byteArrayInputStream.read()))) : (short)(s3 + (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read()));
            }
            this.yCoordinates[n2] = s3;
        }
    }

    private void readFlags(int n, ByteArrayInputStream byteArrayInputStream) {
        try {
            for (int i = 0; i < n; ++i) {
                this.flags[i] = (byte)byteArrayInputStream.read();
                if ((this.flags[i] & 8) == 0) continue;
                int n2 = byteArrayInputStream.read();
                for (int j = 1; j <= n2; ++j) {
                    this.flags[i + j] = this.flags[i];
                }
                i += n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("error: array index out of bounds");
        }
    }
}

