/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Comparator;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.logic.bibtex.comparator.EntryComparator;
import org.jabref.model.entry.BibEntry;

public class BibEntrySuggestionProvider
extends SuggestionProvider<BibEntry>
implements AutoCompleteSuggestionProvider<BibEntry> {
    @Override
    public void indexEntry(BibEntry entry) {
        if (entry == null) {
            return;
        }
        this.addPossibleSuggestions(entry);
    }

    @Override
    protected Comparator<BibEntry> getComparator() {
        return new EntryComparator(false, true, "bibtexkey");
    }

    @Override
    protected boolean isMatch(BibEntry suggestion, AutoCompletionBinding.ISuggestionRequest request) {
        String userTextLower = request.getUserText().toLowerCase();
        return suggestion.getCiteKeyOptional().map(key -> key.toLowerCase().contains(userTextLower)).orElse(false);
    }
}

