/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Objects;
import java.util.StringTokenizer;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.StringSuggestionProvider;
import org.jabref.model.entry.BibEntry;

public class WordSuggestionProvider
extends StringSuggestionProvider
implements AutoCompleteSuggestionProvider<String> {
    private static final String SEPARATING_CHARS = ";,\n ";
    private final String fieldName;

    public WordSuggestionProvider(String fieldName) {
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    @Override
    public void indexEntry(BibEntry entry) {
        if (entry == null) {
            return;
        }
        entry.getField(this.fieldName).ifPresent(fieldValue -> {
            StringTokenizer tok = new StringTokenizer((String)fieldValue, SEPARATING_CHARS);
            while (tok.hasMoreTokens()) {
                this.addPossibleSuggestions(tok.nextToken());
            }
        });
    }
}

