/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jabref.gui.BasePanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.collab.InfoPane;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoablePreambleChange;
import org.jabref.logic.bibtex.comparator.PreambleDiff;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.strings.StringUtil;

class PreambleChangeViewModel
extends ChangeViewModel {
    private final String mem;
    private final String disk;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);

    public PreambleChangeViewModel(String mem, PreambleDiff diff) {
        super(Localization.lang("Changed preamble", new String[0]));
        this.disk = diff.getNewPreamble();
        this.mem = mem;
        StringBuilder text = new StringBuilder(34);
        text.append("<FONT SIZE=3><H2>").append(Localization.lang("Changed preamble", new String[0])).append("</H2>");
        if (StringUtil.isNotBlank(this.disk)) {
            text.append("<H3>").append(Localization.lang("Value set externally", new String[0])).append(":</H3><CODE>").append(this.disk).append("</CODE>");
        } else {
            text.append("<H3>").append(Localization.lang("Value cleared externally", new String[0])).append("</H3>");
        }
        if (StringUtil.isNotBlank(mem)) {
            text.append("<H3>").append(Localization.lang("Current value", new String[0])).append(":</H3><CODE>").append(mem).append("</CODE>");
        }
        this.tp.setText(text.toString());
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        panel.getDatabase().setPreamble(this.disk);
        undoEdit.addEdit(new UndoablePreambleChange(panel.getDatabase(), panel, this.mem, this.disk));
        secondary.setPreamble(this.disk);
        return true;
    }

    @Override
    public JComponent description() {
        return this.sp;
    }
}

