/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import de.saxsys.mvvmfx.utils.validation.ObservableRuleBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.NotificationPane;
import org.jabref.gui.IconTheme;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableChangeType;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.logic.bibtex.LatexFieldFormatter;
import org.jabref.logic.bibtex.LatexFieldFormatterPreferences;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTab
extends EntryEditorTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceTab.class);
    private final LatexFieldFormatterPreferences fieldFormatterPreferences;
    private final BibDatabaseMode mode;
    private final JabRefPreferences preferences;
    private final UndoManager undoManager;
    private final ObjectProperty<ValidationMessage> sourceIsValid = new SimpleObjectProperty();
    private final ObservableRuleBasedValidator sourceValidator = new ObservableRuleBasedValidator(new ObservableValue[]{this.sourceIsValid});
    private final FileUpdateMonitor fileMonitor;

    public SourceTab(BibDatabaseContext bibDatabaseContext, CountingUndoManager undoManager, LatexFieldFormatterPreferences fieldFormatterPreferences, JabRefPreferences preferences, FileUpdateMonitor fileMonitor) {
        this.mode = bibDatabaseContext.getMode();
        this.setText(Localization.lang("%0 source", this.mode.getFormattedName()));
        this.setTooltip(new Tooltip(Localization.lang("Show/edit %0 source", this.mode.getFormattedName())));
        this.setGraphic(IconTheme.JabRefIcon.SOURCE.getGraphicNode());
        this.undoManager = undoManager;
        this.fieldFormatterPreferences = fieldFormatterPreferences;
        this.preferences = preferences;
        this.fileMonitor = fileMonitor;
    }

    private static String getSourceString(BibEntry entry, BibDatabaseMode type, LatexFieldFormatterPreferences fieldFormatterPreferences) throws IOException {
        StringWriter stringWriter = new StringWriter(200);
        LatexFieldFormatter formatter = LatexFieldFormatter.buildIgnoreHashes(fieldFormatterPreferences);
        new BibEntryWriter(formatter, false).writeWithoutPrependedNewlines(entry, stringWriter, type);
        return stringWriter.getBuffer().toString();
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return true;
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        TextArea codeArea = new TextArea();
        ScrollPane scrollPane = new ScrollPane((Node)codeArea);
        NotificationPane notificationPane = new NotificationPane((Node)scrollPane);
        notificationPane.setShowFromTop(false);
        this.sourceValidator.getValidationStatus().getMessages().addListener(c -> {
            if (this.sourceValidator.getValidationStatus().isValid()) {
                notificationPane.hide();
            } else {
                this.sourceValidator.getValidationStatus().getHighestMessage().ifPresent(validationMessage -> notificationPane.show(validationMessage.getMessage()));
            }
        });
        this.setContent((Node)codeArea);
        BindingsHelper.bindContentBidirectional(entry.getFieldsObservable(), codeArea.textProperty(), this::storeSource, fields -> DefaultTaskExecutor.runAndWaitInJavaFXThread(() -> {
            codeArea.clear();
            try {
                codeArea.setText(SourceTab.getSourceString(entry, this.mode, this.fieldFormatterPreferences));
            }
            catch (IOException ex) {
                codeArea.setEditable(false);
                codeArea.appendText(ex.getMessage() + "\n\n" + Localization.lang("Correct the entry, and reopen editor to display/edit source.", new String[0]));
                LOGGER.debug("Incorrect entry", ex);
            }
        }));
    }

    private void storeSource(String text) {
        if (this.currentEntry == null || text.isEmpty()) {
            return;
        }
        BibtexParser bibtexParser = new BibtexParser(this.preferences.getImportFormatPreferences(), this.fileMonitor);
        try {
            String fieldName;
            ParserResult parserResult = bibtexParser.parse(new StringReader(text));
            BibDatabase database = parserResult.getDatabase();
            if (database.getEntryCount() > 1) {
                throw new IllegalStateException("More than one entry found.");
            }
            if (!database.hasEntries()) {
                if (parserResult.hasWarnings()) {
                    throw new IllegalStateException(parserResult.warnings().get(0));
                }
                throw new IllegalStateException("No entries found.");
            }
            NamedCompound compound = new NamedCompound(Localization.lang("source edit", new String[0]));
            BibEntry newEntry = (BibEntry)database.getEntries().get(0);
            String newKey = newEntry.getCiteKeyOptional().orElse(null);
            if (newKey != null) {
                this.currentEntry.setCiteKey(newKey);
            } else {
                this.currentEntry.clearCiteKey();
            }
            for (Map.Entry<String, String> field2 : this.currentEntry.getFieldMap().entrySet()) {
                fieldName = field2.getKey();
                String fieldValue = field2.getValue();
                if (!InternalBibtexFields.isDisplayableField(fieldName) || newEntry.hasField(fieldName)) continue;
                compound.addEdit(new UndoableFieldChange(this.currentEntry, fieldName, fieldValue, null));
                this.currentEntry.clearField(fieldName);
            }
            for (Map.Entry<String, String> field2 : newEntry.getFieldMap().entrySet()) {
                String newValue;
                fieldName = field2.getKey();
                String oldValue = this.currentEntry.getField(fieldName).orElse(null);
                if (Objects.equals(oldValue, newValue = field2.getValue())) continue;
                new LatexFieldFormatter(this.preferences.getLatexFieldFormatterPreferences()).format(newValue, fieldName);
                compound.addEdit(new UndoableFieldChange(this.currentEntry, fieldName, oldValue, newValue));
                this.currentEntry.setField(fieldName, newValue);
            }
            if (!Objects.equals(newEntry.getType(), this.currentEntry.getType())) {
                compound.addEdit(new UndoableChangeType(this.currentEntry, this.currentEntry.getType(), newEntry.getType()));
                this.currentEntry.setType(newEntry.getType());
            }
            compound.end();
            this.undoManager.addEdit(compound);
            this.sourceIsValid.setValue(null);
        }
        catch (IOException | IllegalStateException | InvalidFieldValueException ex) {
            this.sourceIsValid.setValue((Object)ValidationMessage.error(Localization.lang("Problem with parsing entry", new String[0]) + ": " + ex.getMessage()));
            LOGGER.debug("Incorrect source", ex);
        }
    }
}

