/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import javafx.util.StringConverter;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.Date;
import org.jabref.model.strings.StringUtil;

public class DateEditorViewModel
extends AbstractEditorViewModel {
    private final DateTimeFormatter dateFormatter;

    public DateEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, DateTimeFormatter dateFormatter, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.dateFormatter = dateFormatter;
    }

    public StringConverter<TemporalAccessor> getDateToStringConverter() {
        return new StringConverter<TemporalAccessor>(){

            public String toString(TemporalAccessor date) {
                if (date != null) {
                    return DateEditorViewModel.this.dateFormatter.format(date);
                }
                return "";
            }

            public TemporalAccessor fromString(String string) {
                if (StringUtil.isNotBlank(string)) {
                    try {
                        return DateEditorViewModel.this.dateFormatter.parse(string);
                    }
                    catch (DateTimeParseException exception) {
                        return Date.parse(string).map(Date::toTemporalAccessor).orElse(null);
                    }
                }
                return null;
            }
        };
    }
}

