/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.journals.AbbreviationViewModel;
import org.jabref.gui.journals.AbbreviationsFileViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageJournalAbbreviationsViewModel
extends AbstractViewModel {
    private final Logger logger = LoggerFactory.getLogger(ManageJournalAbbreviationsViewModel.class);
    private final SimpleListProperty<AbbreviationsFileViewModel> journalFiles = new SimpleListProperty(FXCollections.observableArrayList());
    private final SimpleListProperty<AbbreviationViewModel> abbreviations = new SimpleListProperty(FXCollections.observableArrayList());
    private final SimpleIntegerProperty abbreviationsCount = new SimpleIntegerProperty();
    private final SimpleObjectProperty<AbbreviationsFileViewModel> currentFile = new SimpleObjectProperty();
    private final SimpleObjectProperty<AbbreviationViewModel> currentAbbreviation = new SimpleObjectProperty();
    private final SimpleBooleanProperty isFileRemovable = new SimpleBooleanProperty();
    private final SimpleBooleanProperty isLoading = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty isLoadingBuiltIn = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty isLoadingIeee = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty isAbbreviationEditableAndRemovable = new SimpleBooleanProperty();
    private final PreferencesService preferences;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final JournalAbbreviationPreferences abbreviationsPreferences;
    private final JournalAbbreviationLoader journalAbbreviationLoader;
    private boolean shouldWriteLists = false;

    public ManageJournalAbbreviationsViewModel(PreferencesService preferences, DialogService dialogService, TaskExecutor taskExecutor, JournalAbbreviationLoader journalAbbreviationLoader) {
        this.preferences = Objects.requireNonNull(preferences);
        this.dialogService = Objects.requireNonNull(dialogService);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.journalAbbreviationLoader = Objects.requireNonNull(journalAbbreviationLoader);
        this.abbreviationsPreferences = preferences.getJournalAbbreviationPreferences();
        this.abbreviationsCount.bind((ObservableValue)this.abbreviations.sizeProperty());
        this.currentAbbreviation.addListener((observable, oldvalue, newvalue) -> {
            boolean isAbbreviation = newvalue != null && !newvalue.isPseudoAbbreviation();
            boolean isEditableFile = this.currentFile.get() != null && !((AbbreviationsFileViewModel)this.currentFile.get()).isBuiltInListProperty().get();
            this.isAbbreviationEditableAndRemovable.set(isAbbreviation && isEditableFile);
        });
        this.currentFile.addListener((observable, oldvalue, newvalue) -> {
            if (oldvalue != null) {
                this.abbreviations.unbindBidirectional(oldvalue.abbreviationsProperty());
                this.currentAbbreviation.set(null);
            }
            if (newvalue != null) {
                this.isFileRemovable.set(!newvalue.isBuiltInListProperty().get());
                this.abbreviations.bindBidirectional(newvalue.abbreviationsProperty());
                if (this.abbreviations.size() > 0) {
                    this.currentAbbreviation.set((Object)((AbbreviationViewModel)this.abbreviations.get(this.abbreviations.size() - 1)));
                }
            } else {
                this.isFileRemovable.set(false);
                if (!this.journalFiles.isEmpty()) {
                    this.currentFile.set((Object)((AbbreviationsFileViewModel)this.journalFiles.get(0)));
                } else {
                    this.currentAbbreviation.set(null);
                    this.abbreviations.clear();
                }
            }
        });
        this.journalFiles.addListener(c -> {
            if (c.next() && !c.wasReplaced() && c.wasAdded() && !((AbbreviationsFileViewModel)c.getAddedSubList().get(0)).isBuiltInListProperty().get()) {
                this.currentFile.set((Object)((AbbreviationsFileViewModel)c.getAddedSubList().get(0)));
            }
        });
        this.isLoading.bind((ObservableValue)this.isLoadingBuiltIn.and((ObservableBooleanValue)this.isLoadingBuiltIn));
    }

    public SimpleBooleanProperty isLoadingProperty() {
        return this.isLoading;
    }

    public boolean isAbbreviationEditableAndRemovable() {
        return this.isAbbreviationEditableAndRemovable.get();
    }

    void addBuiltInLists() {
        BackgroundTask.wrap(JournalAbbreviationLoader::getBuiltInAbbreviations).onRunning(() -> this.isLoadingBuiltIn.setValue(Boolean.valueOf(true))).onSuccess(result -> {
            this.isLoadingBuiltIn.setValue(Boolean.valueOf(false));
            this.addList(Localization.lang("JabRef built in list", new String[0]), (List<Abbreviation>)result);
        }).onFailure(this.dialogService::showErrorDialogAndWait).executeWith(this.taskExecutor);
        BackgroundTask.wrap(() -> {
            if (this.abbreviationsPreferences.useIEEEAbbreviations()) {
                return JournalAbbreviationLoader.getOfficialIEEEAbbreviations();
            }
            return JournalAbbreviationLoader.getStandardIEEEAbbreviations();
        }).onRunning(() -> this.isLoadingIeee.setValue(Boolean.valueOf(true))).onSuccess(result -> {
            this.isLoadingIeee.setValue(Boolean.valueOf(false));
            this.addList(Localization.lang("IEEE built in list", new String[0]), (List<Abbreviation>)result);
        }).onFailure(this.dialogService::showErrorDialogAndWait).executeWith(this.taskExecutor);
    }

    private void addList(String name, List<Abbreviation> abbreviations) {
        ArrayList<AbbreviationViewModel> builtInListViewModel = new ArrayList<AbbreviationViewModel>();
        abbreviations.forEach(abbreviation -> builtInListViewModel.add(new AbbreviationViewModel((Abbreviation)abbreviation)));
        AbbreviationsFileViewModel fileViewModel = new AbbreviationsFileViewModel(builtInListViewModel, name);
        this.journalFiles.add((Object)fileViewModel);
    }

    public void createFileObjects() {
        List<String> externalFiles = this.abbreviationsPreferences.getExternalJournalLists();
        externalFiles.forEach(name -> this.openFile(Paths.get(name, new String[0])));
    }

    public void addNewFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.TXT).build();
        this.dialogService.showFileSaveDialog(fileDialogConfiguration).ifPresent(this::openFile);
    }

    private void openFile(Path filePath) {
        AbbreviationsFileViewModel abbreviationsFile = new AbbreviationsFileViewModel(filePath);
        if (this.journalFiles.contains((Object)abbreviationsFile)) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Duplicated Journal File", new String[0]), Localization.lang("Journal file %s already added", filePath.toString()));
            return;
        }
        if (abbreviationsFile.exists()) {
            try {
                abbreviationsFile.readAbbreviations();
            }
            catch (FileNotFoundException e) {
                this.logger.debug(e.getLocalizedMessage());
            }
        }
        this.journalFiles.add((Object)abbreviationsFile);
    }

    public void openFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.TXT).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(this::openFile);
    }

    public void removeCurrentFile() {
        if (this.isFileRemovable.get()) {
            this.journalFiles.remove(this.currentFile.get());
            if (this.journalFiles.isEmpty()) {
                this.currentFile.set(null);
            }
        }
    }

    public void addAbbreviation(String name, String abbreviation) {
        Abbreviation abbreviationObject = new Abbreviation(name, abbreviation);
        AbbreviationViewModel abbreviationViewModel = new AbbreviationViewModel(abbreviationObject);
        if (this.abbreviations.contains((Object)abbreviationViewModel)) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Duplicated Journal Abbreviation", new String[0]), Localization.lang("Abbreviation %s for journal %s already defined.", abbreviation, name));
        } else {
            this.abbreviations.add((Object)abbreviationViewModel);
            this.currentAbbreviation.set((Object)abbreviationViewModel);
            this.shouldWriteLists = true;
        }
    }

    public void editAbbreviation(String name, String abbreviation) {
        if (this.isAbbreviationEditableAndRemovable.get()) {
            Abbreviation abbreviationObject = new Abbreviation(name, abbreviation);
            AbbreviationViewModel abbViewModel = new AbbreviationViewModel(abbreviationObject);
            if (this.abbreviations.contains((Object)abbViewModel)) {
                if (!abbViewModel.equals(this.currentAbbreviation.get())) {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Duplicated Journal Abbreviation", new String[0]), Localization.lang("Abbreviation %s for journal %s already defined.", abbreviation, name));
                } else {
                    this.setCurrentAbbreviationNameAndAbbreviationIfValid(name, abbreviation);
                }
            } else {
                this.setCurrentAbbreviationNameAndAbbreviationIfValid(name, abbreviation);
            }
        }
    }

    private void setCurrentAbbreviationNameAndAbbreviationIfValid(String name, String abbreviation) {
        if (name.trim().isEmpty()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Name cannot be empty", new String[0]));
            return;
        }
        if (abbreviation.trim().isEmpty()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Abbreviation cannot be empty", new String[0]));
            return;
        }
        ((AbbreviationViewModel)this.currentAbbreviation.get()).setName(name);
        ((AbbreviationViewModel)this.currentAbbreviation.get()).setAbbreviation(abbreviation);
        this.shouldWriteLists = true;
    }

    public void deleteAbbreviation() {
        if (this.isAbbreviationEditableAndRemovable.get() && this.currentAbbreviation.get() != null && !((AbbreviationViewModel)this.currentAbbreviation.get()).isPseudoAbbreviation()) {
            int index = this.abbreviations.indexOf(this.currentAbbreviation.get());
            if (index > 1) {
                this.currentAbbreviation.set((Object)((AbbreviationViewModel)this.abbreviations.get(index - 1)));
            } else if (index + 1 < this.abbreviationsCount.get()) {
                this.currentAbbreviation.set((Object)((AbbreviationViewModel)this.abbreviations.get(index + 1)));
            } else {
                this.currentAbbreviation.set(null);
            }
            this.abbreviations.remove(index);
            this.shouldWriteLists = true;
        }
    }

    public void saveJournalAbbreviationFiles() {
        this.journalFiles.forEach(file -> {
            try {
                file.writeOrCreate();
            }
            catch (IOException e) {
                this.logger.debug(e.getLocalizedMessage());
            }
        });
    }

    private void saveExternalFilesList() {
        ArrayList<String> extFiles = new ArrayList<String>();
        this.journalFiles.forEach(file -> {
            if (!file.isBuiltInListProperty().get()) {
                file.getAbsolutePath().ifPresent(path -> extFiles.add(path.toAbsolutePath().toString()));
            }
        });
        this.abbreviationsPreferences.setExternalJournalLists(extFiles);
    }

    public void selectLastJournalFile() {
        if (this.journalFiles.size() > 0) {
            this.currentFile.set((Object)((AbbreviationsFileViewModel)this.journalFilesProperty().get(this.journalFilesProperty().size() - 1)));
        }
    }

    public void saveEverythingAndUpdateAutoCompleter() {
        this.saveExternalFilesList();
        if (this.shouldWriteLists) {
            this.saveJournalAbbreviationFiles();
            this.shouldWriteLists = false;
        }
        this.journalAbbreviationLoader.update(this.abbreviationsPreferences);
        this.preferences.storeJournalAbbreviationPreferences(this.abbreviationsPreferences);
    }

    public SimpleListProperty<AbbreviationsFileViewModel> journalFilesProperty() {
        return this.journalFiles;
    }

    public SimpleListProperty<AbbreviationViewModel> abbreviationsProperty() {
        return this.abbreviations;
    }

    public SimpleIntegerProperty abbreviationsCountProperty() {
        return this.abbreviationsCount;
    }

    public SimpleObjectProperty<AbbreviationsFileViewModel> currentFileProperty() {
        return this.currentFile;
    }

    public SimpleObjectProperty<AbbreviationViewModel> currentAbbreviationProperty() {
        return this.currentAbbreviation;
    }

    public SimpleBooleanProperty isAbbreviationEditableAndRemovableProperty() {
        return this.isAbbreviationEditableAndRemovable;
    }

    public SimpleBooleanProperty isFileRemovableProperty() {
        return this.isFileRemovable;
    }

    public void addAbbreviation() {
        this.addAbbreviation(Localization.lang("Name", new String[0]), Localization.lang("Abbreviation", new String[0]));
    }

    public void init() {
        this.createFileObjects();
        this.selectLastJournalFile();
        this.addBuiltInLists();
    }
}

