/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.desktop.os.NativeDesktop;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.OpenOfficeFileSearch;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;

public class DetectOpenOfficeInstallation
extends AbstractWorker {
    private final OpenOfficePreferences preferences;
    private final JDialog parent;
    private boolean foundPaths;
    private JDialog progressDialog;

    public DetectOpenOfficeInstallation(JDialog parent, OpenOfficePreferences preferences) {
        this.parent = parent;
        this.preferences = preferences;
    }

    public boolean isInstalled() {
        this.foundPaths = false;
        if (this.checkAutoDetectedPaths(this.preferences)) {
            return true;
        }
        this.init();
        this.getWorker().run();
        this.update();
        return this.foundPaths;
    }

    @Override
    public void run() {
        this.foundPaths = this.autoDetectPaths();
    }

    @Override
    public void init() {
        this.progressDialog = this.showProgressDialog(this.parent, Localization.lang("Autodetecting paths...", new String[0]), Localization.lang("Please wait...", new String[0]));
    }

    @Override
    public void update() {
        this.progressDialog.dispose();
    }

    private Optional<Path> selectInstallationPath() {
        NativeDesktop nativeDesktop = JabRefDesktop.getNativeDesktop();
        JOptionPane.showMessageDialog(this.parent, Localization.lang("Unable to autodetect OpenOffice/LibreOffice installation. Please choose the installation directory manually.", new String[0]), Localization.lang("Could not find OpenOffice/LibreOffice installation", new String[0]), 1);
        FXDialogService ds = new FXDialogService();
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(nativeDesktop.getApplicationDirectory()).build();
        Optional path = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showDirectorySelectionDialog(dirDialogConfiguration));
        if (path.isPresent()) {
            return path;
        }
        return Optional.empty();
    }

    private boolean autoDetectPaths() {
        Optional<Path> actualFile;
        List<Path> installations = OpenOfficeFileSearch.detectInstallations();
        if (installations.isEmpty()) {
            this.selectInstallationPath().ifPresent(installations::add);
        }
        if ((actualFile = this.chooseAmongInstallations(installations)).isPresent()) {
            return this.setOpenOfficePreferences(actualFile.get());
        }
        return false;
    }

    private boolean checkAutoDetectedPaths(OpenOfficePreferences openOfficePreferences) {
        String executablePath = openOfficePreferences.getExecutablePath();
        return executablePath != null && Files.exists(Paths.get(executablePath, new String[0]), new LinkOption[0]);
    }

    private boolean setOpenOfficePreferences(Path installDir) {
        Optional<Object> execPath = Optional.empty();
        if (OS.WINDOWS) {
            execPath = FileUtil.find("soffice.exe", installDir);
        } else if (OS.OS_X) {
            execPath = FileUtil.find("soffice", installDir);
        } else if (OS.LINUX) {
            execPath = FileUtil.find("soffice", installDir);
        }
        Optional<Path> jarFilePath = FileUtil.find(OpenOfficePreferences.OO_JARS.get(0), installDir);
        if (execPath.isPresent() && jarFilePath.isPresent()) {
            this.preferences.setInstallationPath(installDir.toString());
            this.preferences.setExecutablePath(((Path)execPath.get()).toString());
            this.preferences.setJarsPath(jarFilePath.get().getParent().toString());
            return true;
        }
        return false;
    }

    private Optional<Path> chooseAmongInstallations(List<Path> installDirs) {
        if (installDirs.isEmpty()) {
            return Optional.empty();
        }
        if (installDirs.size() == 1) {
            return Optional.of(installDirs.get(0).toAbsolutePath());
        }
        DefaultListModel<File> mod = new DefaultListModel<File>();
        for (Path tmpfile : installDirs) {
            mod.addElement(tmpfile.toFile());
        }
        JList fileList = new JList(mod);
        fileList.setSelectionMode(0);
        fileList.setSelectedIndex(0);
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("pref:grow", "pref, 2dlu, pref, 4dlu, pref"));
        builder.add(Localization.lang("Found more than one OpenOffice/LibreOffice executable.", new String[0]), new Object[0]).xy(1, 1);
        builder.add(Localization.lang("Please choose which one to connect to:", new String[0]), new Object[0]).xy(1, 3);
        builder.add(fileList).xy(1, 5);
        int answer = JOptionPane.showConfirmDialog(null, builder.getPanel(), Localization.lang("Choose OpenOffice/LibreOffice executable", new String[0]), 2);
        if (answer == 2) {
            return Optional.empty();
        }
        return Optional.of(((File)fileList.getSelectedValue()).toPath());
    }

    public JDialog showProgressDialog(JDialog progressParent, String title, String message) {
        JProgressBar bar = new JProgressBar(0);
        JDialog progressDialog = new JDialog(progressParent, title, false);
        bar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        bar.setIndeterminate(true);
        progressDialog.add((Component)new JLabel(message), "North");
        progressDialog.add((Component)bar, "Center");
        progressDialog.pack();
        progressDialog.setLocationRelativeTo(null);
        progressDialog.setVisible(true);
        return progressDialog;
    }
}

