/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.WindowLocation;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.OOBibStyle;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.openoffice.StyleLoader;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.TestEntry;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StyleSelectDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleSelectDialog.class);
    private final JabRefFrame frame;
    private EventList<OOBibStyle> styles;
    private JDialog diag;
    private JTable table;
    private DefaultEventTableModel<OOBibStyle> tableModel;
    private DefaultEventSelectionModel<OOBibStyle> selectionModel;
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem edit = new JMenuItem(Localization.lang("Edit", new String[0]));
    private final JMenuItem show = new JMenuItem(Localization.lang("View", new String[0]));
    private final JMenuItem remove = new JMenuItem(Localization.lang("Remove", new String[0]));
    private final JMenuItem reload = new JMenuItem(Localization.lang("Reload", new String[0]));
    private final JButton addButton = new JButton(IconTheme.JabRefIcon.ADD_NOBOX.getIcon());
    private final JButton removeButton = new JButton(IconTheme.JabRefIcon.REMOVE_NOBOX.getIcon());
    private PreviewPanel preview;
    private ActionListener removeAction;
    private final Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
    private final BibEntry prevEntry;
    private boolean okPressed;
    private final StyleLoader loader;
    private final OpenOfficePreferences preferences;

    public StyleSelectDialog(JabRefFrame frame, OpenOfficePreferences preferences, StyleLoader loader) {
        this.frame = Objects.requireNonNull(frame);
        this.preferences = Objects.requireNonNull(preferences);
        this.loader = Objects.requireNonNull(loader);
        this.prevEntry = TestEntry.getTestEntry();
        this.init();
    }

    private void init() {
        this.setupPopupMenu();
        this.addButton.addActionListener(actionEvent -> {
            AddFileDialog addDialog = new AddFileDialog();
            addDialog.setDirectoryPath(this.preferences.getCurrentStyle());
            addDialog.setVisible(true);
            addDialog.getFileName().ifPresent(fileName -> {
                if (this.loader.addStyleIfValid((String)fileName)) {
                    this.preferences.setCurrentStyle((String)fileName);
                }
            });
            this.updateStyles();
        });
        this.addButton.setToolTipText(Localization.lang("Add style file", new String[0]));
        this.removeButton.addActionListener(this.removeAction);
        this.removeButton.setToolTipText(Localization.lang("Remove style", new String[0]));
        this.preview = new PreviewPanel(null, null);
        this.preview.setEntry(this.prevEntry);
        this.setupTable();
        this.updateStyles();
        this.diag = new JDialog(this.frame, Localization.lang("Select style", new String[0]), true);
        FormBuilder builder = FormBuilder.create();
        builder.layout(new FormLayout("fill:pref:grow, 4dlu, left:pref, 4dlu, left:pref", "pref, 4dlu, 100dlu:grow, 4dlu, pref, 4dlu, fill:100dlu"));
        builder.add(Localization.lang("Select one of the available styles or add a style file from disk.", new String[0]), new Object[0]).xyw(1, 1, 5);
        builder.add(new JScrollPane(this.table)).xyw(1, 3, 5);
        builder.add(this.addButton).xy(3, 5);
        builder.add(this.removeButton).xy(5, 5);
        JFXPanel container = CustomJFXPanel.wrap(new Scene((Parent)this.preview));
        builder.add((Component)container).xyw(1, 7, 5);
        builder.padding("5dlu, 5dlu, 5dlu, 5dlu", new Object[0]);
        this.diag.add((Component)builder.getPanel(), "Center");
        AbstractAction okListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (StyleSelectDialog.this.table.getRowCount() == 0 || StyleSelectDialog.this.table.getSelectedRowCount() == 0) {
                    JOptionPane.showMessageDialog(StyleSelectDialog.this.diag, Localization.lang("You must select a valid style file.", new String[0]), Localization.lang("Style selection", new String[0]), 0);
                    return;
                }
                StyleSelectDialog.this.okPressed = true;
                StyleSelectDialog.this.storeSettings();
                StyleSelectDialog.this.diag.dispose();
            }
        };
        this.ok.addActionListener(okListener);
        AbstractAction cancelListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StyleSelectDialog.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelListener);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)bb.getPanel(), "South");
        ActionMap am = bb.getPanel().getActionMap();
        InputMap im = bb.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelListener);
        im.put(KeyStroke.getKeyStroke("ENTER"), "enterOk");
        am.put("enterOk", okListener);
        this.diag.pack();
        WindowLocation pw = new WindowLocation(this.diag, "stylesPosX", "stylesPosY", "stylesSizeX", "stylesSizeY");
        pw.displayWindowAtStoredLocation();
    }

    private void setupTable() {
        this.styles = new BasicEventList<OOBibStyle>();
        SortedList<OOBibStyle> sortedStyles = new SortedList<OOBibStyle>(this.styles);
        this.tableModel = (DefaultEventTableModel)GlazedListsSwing.eventTableModelWithThreadProxyList(sortedStyles, new StyleTableFormat());
        this.table = new JTable(this.tableModel);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(1).setPreferredWidth(200);
        cm.getColumn(2).setPreferredWidth(80);
        this.selectionModel = (DefaultEventSelectionModel)GlazedListsSwing.eventSelectionModelWithThreadProxyList(sortedStyles);
        this.table.setSelectionModel(this.selectionModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StyleSelectDialog.this.tablePopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StyleSelectDialog.this.tablePopup(mouseEvent);
                }
            }
        });
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
    }

    private void setupPopupMenu() {
        this.popup.add(this.edit);
        this.popup.add(this.show);
        this.popup.add(this.remove);
        this.popup.add(this.reload);
        this.edit.addActionListener(actionEvent -> this.getSelectedStyle().ifPresent(style -> {
            Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByExt("jstyle");
            String link = style.getPath();
            try {
                if (type.isPresent()) {
                    JabRefDesktop.openExternalFileAnyFormat(new BibDatabaseContext(), link, type);
                } else {
                    JabRefDesktop.openExternalFileUnknown(this.frame, new BibEntry(), new BibDatabaseContext(), link, new UnknownExternalFileType("jstyle"));
                }
            }
            catch (IOException e) {
                LOGGER.warn("Problem open style file editor", e);
            }
        }));
        this.show.addActionListener(actionEvent -> this.getSelectedStyle().ifPresent(this::displayStyle));
        this.removeAction = actionEvent -> this.getSelectedStyle().ifPresent(style -> {
            if (!style.isFromResource() && JOptionPane.showConfirmDialog(this.diag, Localization.lang("Are you sure you want to remove the style?", new String[0]), Localization.lang("Remove style", new String[0]), 0) == 0) {
                if (!this.loader.removeStyle((OOBibStyle)style)) {
                    LOGGER.info("Problem removing style");
                }
                this.updateStyles();
            }
        });
        this.remove.addActionListener(this.removeAction);
        this.reload.addActionListener(actionEvent -> this.getSelectedStyle().ifPresent(style -> {
            try {
                style.ensureUpToDate();
            }
            catch (IOException e) {
                LOGGER.warn("Problem with style file '" + style.getPath() + "'", e);
            }
        }));
    }

    public void setVisible(boolean visible) {
        this.okPressed = false;
        this.diag.setVisible(visible);
    }

    private void updateStyles() {
        this.table.clearSelection();
        this.styles.getReadWriteLock().writeLock().lock();
        this.styles.clear();
        this.styles.addAll(this.loader.getStyles());
        this.styles.getReadWriteLock().writeLock().unlock();
        this.selectLastUsed();
    }

    private void selectLastUsed() {
        String usedStyleFile = this.preferences.getCurrentStyle();
        if (usedStyleFile == null) {
            if (this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        } else {
            boolean found = false;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!usedStyleFile.equals(this.tableModel.getElementAt(i).getPath())) continue;
                this.table.setRowSelectionInterval(i, i);
                found = true;
                break;
            }
            if (!found && this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void storeSettings() {
        this.getSelectedStyle().ifPresent(style -> this.preferences.setCurrentStyle(style.getPath()));
    }

    public Optional<OOBibStyle> getStyle() {
        if (this.okPressed) {
            return this.getSelectedStyle();
        }
        return Optional.empty();
    }

    private Optional<OOBibStyle> getSelectedStyle() {
        if (!this.selectionModel.getSelected().isEmpty()) {
            return Optional.of((OOBibStyle)this.selectionModel.getSelected().get(0));
        }
        return Optional.empty();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void tablePopup(MouseEvent e) {
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void displayStyle(OOBibStyle style) {
        JDialog dd = new JDialog(this.diag, style.getName(), true);
        JTextArea ta = new JTextArea(style.getLocalCopy());
        ta.setEditable(false);
        JScrollPane sp2 = new JScrollPane(ta);
        sp2.setPreferredSize(new Dimension(700, 500));
        dd.getContentPane().add((Component)sp2, "Center");
        JButton okButton = new JButton(Localization.lang("OK", new String[0]));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)okButton);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dd.getContentPane().add((Component)bb.getPanel(), "South");
        okButton.addActionListener(actionEvent -> dd.dispose());
        dd.pack();
        dd.setLocationRelativeTo(this.diag);
        dd.setVisible(true);
    }

    private class AddFileDialog
    extends JabRefDialog {
        private final JTextField newFile;
        private boolean addOKPressed;

        public AddFileDialog() {
            super((Dialog)StyleSelectDialog.this.diag, Localization.lang("Add style file", new String[0]), true, AddFileDialog.class);
            this.newFile = new JTextField();
            JButton browse = new JButton(Localization.lang("Browse", new String[0]));
            FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Style file", new String[0]), (FileType)StandardFileType.JSTYLE).withDefaultExtension(Localization.lang("Style file", new String[0]), StandardFileType.JSTYLE).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
            FXDialogService ds = new FXDialogService();
            browse.addActionListener(e -> {
                Optional file = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
                file.ifPresent(f -> this.newFile.setText(f.toAbsolutePath().toString()));
            });
            FormBuilder builder = FormBuilder.create();
            builder.layout(new FormLayout("left:pref, 4dlu, fill:100dlu:grow, 4dlu, pref", "p"));
            builder.add(Localization.lang("File", new String[0]), new Object[0]).xy(1, 1);
            builder.add(this.newFile).xy(3, 1);
            builder.add(browse).xy(5, 1);
            builder.padding("10dlu, 10dlu, 10dlu, 10dlu", new Object[0]);
            this.getContentPane().add((Component)builder.build(), "Center");
            ButtonBarBuilder bb = new ButtonBarBuilder();
            JButton addOKButton = new JButton(Localization.lang("OK", new String[0]));
            JButton addCancelButton = new JButton(Localization.lang("Cancel", new String[0]));
            bb.addGlue();
            bb.addButton((JComponent)addOKButton);
            bb.addButton((JComponent)addCancelButton);
            bb.addGlue();
            bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)bb.getPanel(), "South");
            addOKButton.addActionListener(e -> {
                this.addOKPressed = true;
                this.dispose();
            });
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddFileDialog.this.addOKPressed = false;
                    AddFileDialog.this.dispose();
                }
            };
            addCancelButton.addActionListener(cancelAction);
            bb.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            bb.getPanel().getActionMap().put("close", cancelAction);
            this.pack();
            this.setLocationRelativeTo(StyleSelectDialog.this.diag);
        }

        public Optional<String> getFileName() {
            if (this.addOKPressed && this.newFile.getText() != null && !this.newFile.getText().isEmpty()) {
                return Optional.of(this.newFile.getText());
            }
            return Optional.empty();
        }

        public void setDirectoryPath(String path) {
            this.newFile.setText(path);
        }
    }

    private class EntrySelectionListener
    implements ListEventListener<OOBibStyle> {
        private EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<OOBibStyle> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                OOBibStyle style = (OOBibStyle)listEvent.getSourceList().get(0);
                if (style.isFromResource()) {
                    StyleSelectDialog.this.remove.setEnabled(false);
                    StyleSelectDialog.this.edit.setEnabled(false);
                    StyleSelectDialog.this.reload.setEnabled(false);
                    StyleSelectDialog.this.removeButton.setEnabled(false);
                } else {
                    StyleSelectDialog.this.remove.setEnabled(true);
                    StyleSelectDialog.this.edit.setEnabled(true);
                    StyleSelectDialog.this.reload.setEnabled(true);
                    StyleSelectDialog.this.removeButton.setEnabled(true);
                }
                StyleSelectDialog.this.preview.setLayout(style.getReferenceFormat("default"));
            }
        }
    }

    static class StyleTableFormat
    implements TableFormat<OOBibStyle> {
        StyleTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return Localization.lang("Name", new String[0]);
                }
                case 1: {
                    return Localization.lang("Journals", new String[0]);
                }
                case 2: {
                    return Localization.lang("File", new String[0]);
                }
            }
            return "";
        }

        @Override
        public Object getColumnValue(OOBibStyle style, int i) {
            switch (i) {
                case 0: {
                    return style.getName();
                }
                case 1: {
                    return String.join((CharSequence)", ", style.getJournals());
                }
                case 2: {
                    return style.isFromResource() ? Localization.lang("Internal style", new String[0]) : style.getFile().getName();
                }
            }
            return "";
        }
    }
}

