/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.protectedterms;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;

public class NewProtectedTermsFileDialog
extends JabRefDialog {
    private final JTextField newFile = new JTextField();
    private final JTextField newDescription = new JTextField();
    private final JCheckBox enabled = new JCheckBox(Localization.lang("Enabled", new String[0]));
    private boolean addOKPressed;
    private final ProtectedTermsLoader loader;
    private JFrame parent;

    public NewProtectedTermsFileDialog(JDialog parent, ProtectedTermsLoader loader) {
        super((Dialog)parent, Localization.lang("New protected terms file", new String[0]), true, NewProtectedTermsFileDialog.class);
        this.loader = loader;
        this.setupDialog();
        this.setLocationRelativeTo(parent);
    }

    public NewProtectedTermsFileDialog(JabRefFrame mainFrame, ProtectedTermsLoader loader) {
        super((Frame)mainFrame, Localization.lang("New protected terms file", new String[0]), true, NewProtectedTermsFileDialog.class);
        this.parent = mainFrame;
        this.loader = loader;
        this.setupDialog();
        this.setLocationRelativeTo(mainFrame);
    }

    private void setupDialog() {
        JButton browse = new JButton(Localization.lang("Browse", new String[0]));
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Protected terms file", new String[0]), (FileType)StandardFileType.TERMS).withDefaultExtension(Localization.lang("Protected terms file", new String[0]), StandardFileType.TERMS).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        FXDialogService ds = new FXDialogService();
        browse.addActionListener(e -> {
            Optional file = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileSaveDialog(fileDialogConfiguration));
            file.ifPresent(f -> this.newFile.setText(f.toAbsolutePath().toString()));
        });
        FormBuilder builder = FormBuilder.create();
        builder.layout(new FormLayout("left:pref, 4dlu, fill:100dlu:grow, 4dlu, pref", "p, 4dlu, p, 4dlu, p"));
        builder.add(Localization.lang("Description", new String[0]), new Object[0]).xy(1, 1);
        builder.add(this.newDescription).xyw(3, 1, 3);
        builder.add(Localization.lang("File", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.newFile).xy(3, 3);
        builder.add(browse).xy(5, 3);
        builder.add(this.enabled).xyw(1, 5, 5);
        this.enabled.setSelected(true);
        builder.padding("10dlu, 10dlu, 10dlu, 10dlu", new Object[0]);
        this.getContentPane().add((Component)builder.build(), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JButton addOKButton = new JButton(Localization.lang("OK", new String[0]));
        JButton addCancelButton = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addGlue();
        bb.addButton((JComponent)addOKButton);
        bb.addButton((JComponent)addCancelButton);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)bb.getPanel(), "South");
        addOKButton.addActionListener(e -> {
            this.addOKPressed = true;
            this.loader.addNewProtectedTermsList(this.newDescription.getText(), this.newFile.getText(), this.enabled.isSelected());
            this.dispose();
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewProtectedTermsFileDialog.this.addOKPressed = false;
                NewProtectedTermsFileDialog.this.dispose();
            }
        };
        addCancelButton.addActionListener(cancelAction);
        bb.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        bb.getPanel().getActionMap().put("close", cancelAction);
        this.pack();
    }

    public boolean isOKPressed() {
        return this.addOKPressed;
    }
}

