/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import org.jabref.gui.util.MappedList;

public class BindingsHelper {
    private BindingsHelper() {
    }

    public static <T> BooleanBinding any(ObservableList<T> source, Predicate<T> predicate) {
        return Bindings.createBooleanBinding(() -> source.stream().anyMatch(predicate), (Observable[])new Observable[]{source});
    }

    public static <T> BooleanBinding all(ObservableList<T> source, Predicate<T> predicate) {
        return Bindings.createBooleanBinding(() -> !source.isEmpty() && source.stream().allMatch(predicate), (Observable[])new Observable[]{source});
    }

    public static void includePseudoClassWhen(final Node node, final PseudoClass pseudoClass, ObservableValue<? extends Boolean> condition) {
        BooleanPropertyBase pseudoClassState = new BooleanPropertyBase(false){

            protected void invalidated() {
                node.pseudoClassStateChanged(pseudoClass, this.get());
            }

            public Object getBean() {
                return node;
            }

            public String getName() {
                return pseudoClass.getPseudoClassName();
            }
        };
        pseudoClassState.bind(condition);
    }

    public static <A, B> MappedList<B, A> mapBacked(ObservableList<A> source, Function<A, B> mapper) {
        return new MappedList<B, A>(source, mapper);
    }

    public static <A, B> void bindBidirectional(Property<A> propertyA, Property<B> propertyB, Function<A, B> mapAtoB, Function<B, A> mapBtoA) {
        Consumer<Object> updateA = newValueB -> propertyA.setValue(mapBtoA.apply(newValueB));
        Consumer<Object> updateB = newValueA -> propertyB.setValue(mapAtoB.apply(newValueA));
        BindingsHelper.bindBidirectional(propertyA, propertyB, updateA, updateB);
    }

    public static <A> void bindBidirectional(Property<A> propertyA, ObservableValue<A> propertyB, Consumer<A> updateB) {
        BindingsHelper.bindBidirectional(propertyA, propertyB, arg_0 -> propertyA.setValue(arg_0), updateB);
    }

    public static <A, B> void bindBidirectional(ObservableValue<A> propertyA, ObservableValue<B> propertyB, Consumer<B> updateA, Consumer<A> updateB) {
        BidirectionalBinding<A, B> binding = new BidirectionalBinding<A, B>(propertyA, propertyB, updateA, updateB);
        updateA.accept(propertyB.getValue());
        propertyA.addListener(binding.getChangeListenerA());
        propertyB.addListener(binding.getChangeListenerB());
    }

    public static <A, B> void bindContentBidirectional(ObservableList<A> propertyA, ListProperty<B> propertyB, Consumer<ObservableList<B>> updateA, Consumer<List<A>> updateB) {
        BindingsHelper.bindContentBidirectional(propertyA, propertyB, updateA, updateB);
    }

    public static <A, B> void bindContentBidirectional(ObservableList<A> propertyA, ObservableValue<B> propertyB, Consumer<B> updateA, Consumer<List<A>> updateB) {
        BidirectionalListBinding<A, B> binding = new BidirectionalListBinding<A, B>(propertyA, propertyB, updateA, updateB);
        updateA.accept(propertyB.getValue());
        propertyA.addListener(binding);
        propertyB.addListener(binding);
    }

    public static <A, B> void bindContentBidirectional(ListProperty<A> listProperty, Property<B> property, Function<List<A>, B> mapToB, Function<B, List<A>> mapToList) {
        Consumer<Object> updateList = newValueB -> listProperty.setAll((Collection)mapToList.apply(newValueB));
        Consumer<List<A>> updateB = newValueList -> property.setValue(mapToB.apply((List)newValueList));
        BindingsHelper.bindContentBidirectional(listProperty, property, updateList, updateB);
    }

    public static <A, V, B> void bindContentBidirectional(ObservableMap<A, V> propertyA, ObservableValue<B> propertyB, Consumer<B> updateA, Consumer<Map<A, V>> updateB) {
        BidirectionalMapBinding<A, V, B> binding = new BidirectionalMapBinding<A, V, B>(propertyA, propertyB, updateA, updateB);
        updateB.accept((Map<A, V>)propertyA);
        propertyA.addListener(binding);
        propertyB.addListener(binding);
    }

    public static <A, V, B> void bindContentBidirectional(ObservableMap<A, V> propertyA, Property<B> propertyB, Consumer<B> updateA, Function<Map<A, V>, B> mapToB) {
        Consumer<Map<A, V>> updateB = newValueList -> propertyB.setValue(mapToB.apply((Map)newValueList));
        BindingsHelper.bindContentBidirectional(propertyA, propertyB, updateA, updateB);
    }

    private static class BidirectionalMapBinding<A, V, B>
    implements MapChangeListener<A, V>,
    ChangeListener<B> {
        private final ObservableMap<A, V> mapProperty;
        private final ObservableValue<B> property;
        private final Consumer<B> updateA;
        private final Consumer<Map<A, V>> updateB;
        private boolean updating = false;

        public BidirectionalMapBinding(ObservableMap<A, V> mapProperty, ObservableValue<B> property, Consumer<B> updateA, Consumer<Map<A, V>> updateB) {
            this.mapProperty = mapProperty;
            this.property = property;
            this.updateA = updateA;
            this.updateB = updateB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(ObservableValue<? extends B> observable, B oldValue, B newValue) {
            if (!this.updating) {
                try {
                    this.updating = true;
                    this.updateA.accept(newValue);
                }
                finally {
                    this.updating = false;
                }
            }
        }

        public void onChanged(MapChangeListener.Change<? extends A, ? extends V> c) {
            if (!this.updating) {
                try {
                    this.updating = true;
                    this.updateB.accept((Map<A, V>)this.mapProperty);
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    private static class BidirectionalListBinding<A, B>
    implements ListChangeListener<A>,
    ChangeListener<B> {
        private final ObservableList<A> listProperty;
        private final ObservableValue<B> property;
        private final Consumer<B> updateA;
        private final Consumer<List<A>> updateB;
        private boolean updating = false;

        public BidirectionalListBinding(ObservableList<A> listProperty, ObservableValue<B> property, Consumer<B> updateA, Consumer<List<A>> updateB) {
            this.listProperty = listProperty;
            this.property = property;
            this.updateA = updateA;
            this.updateB = updateB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(ObservableValue<? extends B> observable, B oldValue, B newValue) {
            if (!this.updating) {
                try {
                    this.updating = true;
                    this.updateA.accept(newValue);
                }
                finally {
                    this.updating = false;
                }
            }
        }

        public void onChanged(ListChangeListener.Change<? extends A> c) {
            if (!this.updating) {
                try {
                    this.updating = true;
                    this.updateB.accept((List<A>)this.listProperty);
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    private static class BidirectionalBinding<A, B> {
        private final ObservableValue<A> propertyA;
        private final Consumer<B> updateA;
        private final Consumer<A> updateB;
        private boolean updating = false;

        public BidirectionalBinding(ObservableValue<A> propertyA, ObservableValue<B> propertyB, Consumer<B> updateA, Consumer<A> updateB) {
            this.propertyA = propertyA;
            this.updateA = updateA;
            this.updateB = updateB;
        }

        public ChangeListener<? super A> getChangeListenerA() {
            return this::changedA;
        }

        public ChangeListener<? super B> getChangeListenerB() {
            return this::changedB;
        }

        public void changedA(ObservableValue<? extends A> observable, A oldValue, A newValue) {
            this.updateLocked(this.updateB, oldValue, newValue);
        }

        public void changedB(ObservableValue<? extends B> observable, B oldValue, B newValue) {
            this.updateLocked(this.updateA, oldValue, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> void updateLocked(Consumer<T> update, T oldValue, T newValue) {
            if (!this.updating) {
                try {
                    this.updating = true;
                    update.accept(newValue);
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }
}

