/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util.component;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.util.ControlHelper;

public class Tag<T>
extends HBox {
    private ObjectProperty<T> value;
    private Consumer<T> tagRemovedConsumer;
    @FXML
    private Label text;

    public Tag(Function<T, String> toString) {
        Objects.requireNonNull(toString);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.value = new SimpleObjectProperty();
        this.text.textProperty().bind(EasyBind.map(this.value, toString));
    }

    public Tag(Function<T, String> toString, T value) {
        this(toString);
        this.setValue(value);
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public void setValue(T value) {
        this.value.set(value);
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    @FXML
    private void removeButtonClicked(ActionEvent event) {
        if (this.tagRemovedConsumer != null) {
            this.tagRemovedConsumer.accept(this.value.get());
        }
    }

    public final void setOnTagRemoved(Consumer<T> tagRemovedConsumer) {
        this.tagRemovedConsumer = tagRemovedConsumer;
    }
}

