/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst;

import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BibtexCaseChanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibtexCaseChanger.class);
    private boolean prevColon = true;
    private int braceLevel;

    private BibtexCaseChanger() {
    }

    public static String changeCase(String s2, FORMAT_MODE format) {
        return new BibtexCaseChanger().doChangeCase(s2, format);
    }

    private String doChangeCase(String s2, FORMAT_MODE format) {
        char[] c = s2.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int n = s2.length();
        while (i < n) {
            if (c[i] == '{') {
                ++this.braceLevel;
                if (this.braceLevel != 1 || i + 4 > n || c[i + 1] != '\\') {
                    this.prevColon = false;
                    sb.append(c[i]);
                    ++i;
                    continue;
                }
                if (format == FORMAT_MODE.TITLE_LOWERS && (i == 0 || this.prevColon && Character.isWhitespace(c[i - 1]))) {
                    sb.append('{');
                    ++i;
                    this.prevColon = false;
                    continue;
                }
                i = this.convertSpecialChar(sb, c, i, format);
                continue;
            }
            if (c[i] == '}') {
                sb.append(c[i]);
                ++i;
                if (this.braceLevel == 0) {
                    LOGGER.warn("Too many closing braces in string: " + s2);
                } else {
                    --this.braceLevel;
                }
                this.prevColon = false;
                continue;
            }
            if (this.braceLevel == 0) {
                i = this.convertCharIfBraceLevelIsZero(c, i, sb, format);
                continue;
            }
            sb.append(c[i]);
            ++i;
        }
        if (this.braceLevel > 0) {
            LOGGER.warn("No enough closing braces in string: " + s2);
        }
        return sb.toString();
    }

    private int convertSpecialChar(StringBuilder sb, char[] c, int start, FORMAT_MODE format) {
        int i = start;
        sb.append(c[i]);
        ++i;
        while (i < c.length && this.braceLevel > 0) {
            sb.append(c[i]);
            Optional<String> s2 = BibtexCaseChanger.findSpecialChar(c, ++i);
            if (s2.isPresent()) {
                i = this.convertAccented(c, i, s2.get(), sb, format);
            }
            while (i < c.length && this.braceLevel > 0 && c[i] != '\\') {
                if (c[i] == '}') {
                    --this.braceLevel;
                } else if (c[i] == '{') {
                    ++this.braceLevel;
                }
                i = this.convertNonControl(c, i, sb, format);
            }
        }
        return i;
    }

    private int convertAccented(char[] c, int start, String s2, StringBuilder sb, FORMAT_MODE format) {
        int pos = start;
        pos += s2.length();
        switch (format) {
            case TITLE_LOWERS: 
            case ALL_LOWERS: {
                if ("L O OE AE AA".contains(s2)) {
                    sb.append(s2.toLowerCase(Locale.ROOT));
                    break;
                }
                sb.append(s2);
                break;
            }
            case ALL_UPPERS: {
                if ("l o oe ae aa".contains(s2)) {
                    sb.append(s2.toUpperCase(Locale.ROOT));
                    break;
                }
                if ("i j ss".contains(s2)) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append(s2.toUpperCase(Locale.ROOT));
                    while (pos < c.length && Character.isWhitespace(c[pos])) {
                        ++pos;
                    }
                    break;
                }
                sb.append(s2);
                break;
            }
            default: {
                LOGGER.info("convertAccented - Unknown format: " + (Object)((Object)format));
            }
        }
        return pos;
    }

    private int convertNonControl(char[] c, int start, StringBuilder sb, FORMAT_MODE format) {
        int pos = start;
        switch (format) {
            case TITLE_LOWERS: 
            case ALL_LOWERS: {
                sb.append(Character.toLowerCase(c[pos]));
                ++pos;
                break;
            }
            case ALL_UPPERS: {
                sb.append(Character.toUpperCase(c[pos]));
                ++pos;
                break;
            }
            default: {
                LOGGER.info("convertNonControl - Unknown format: " + (Object)((Object)format));
            }
        }
        return pos;
    }

    private int convertCharIfBraceLevelIsZero(char[] c, int start, StringBuilder sb, FORMAT_MODE format) {
        int i = start;
        switch (format) {
            case TITLE_LOWERS: {
                if (i == 0 || this.prevColon && Character.isWhitespace(c[i - 1])) {
                    sb.append(c[i]);
                } else {
                    sb.append(Character.toLowerCase(c[i]));
                }
                if (c[i] == ':') {
                    this.prevColon = true;
                    break;
                }
                if (Character.isWhitespace(c[i])) break;
                this.prevColon = false;
                break;
            }
            case ALL_LOWERS: {
                sb.append(Character.toLowerCase(c[i]));
                break;
            }
            case ALL_UPPERS: {
                sb.append(Character.toUpperCase(c[i]));
                break;
            }
            default: {
                LOGGER.info("convertCharIfBraceLevelIsZero - Unknown format: " + (Object)((Object)format));
            }
        }
        return ++i;
    }

    public static Optional<String> findSpecialChar(char[] c, int pos) {
        if (pos + 1 < c.length) {
            if (c[pos] == 'o' && c[pos + 1] == 'e') {
                return Optional.of("oe");
            }
            if (c[pos] == 'O' && c[pos + 1] == 'E') {
                return Optional.of("OE");
            }
            if (c[pos] == 'a' && c[pos + 1] == 'e') {
                return Optional.of("ae");
            }
            if (c[pos] == 'A' && c[pos + 1] == 'E') {
                return Optional.of("AE");
            }
            if (c[pos] == 's' && c[pos + 1] == 's') {
                return Optional.of("ss");
            }
            if (c[pos] == 'A' && c[pos + 1] == 'A') {
                return Optional.of("AA");
            }
            if (c[pos] == 'a' && c[pos + 1] == 'a') {
                return Optional.of("aa");
            }
        }
        if ("ijoOlL".indexOf(c[pos]) >= 0) {
            return Optional.of(String.valueOf(c[pos]));
        }
        return Optional.empty();
    }

    public static enum FORMAT_MODE {
        TITLE_LOWERS('t'),
        ALL_LOWERS('l'),
        ALL_UPPERS('u');

        private final char asChar;

        private FORMAT_MODE(char asChar) {
            this.asChar = asChar;
        }

        public char asChar() {
            return this.asChar;
        }

        public static FORMAT_MODE getFormatModeForBSTFormat(char bstFormat) {
            for (FORMAT_MODE mode : FORMAT_MODE.values()) {
                if (mode.asChar != bstFormat) continue;
                return mode;
            }
            throw new IllegalArgumentException();
        }
    }
}

