/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.util.strings.HTMLUnicodeConversionMaps;
import org.jabref.model.cleanup.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToLatexFormatter
extends Formatter
implements LayoutFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlToLatexFormatter.class);
    private static final int MAX_TAG_LENGTH = 100;
    private static final Pattern ESCAPED_PATTERN = Pattern.compile("&#([x]*)([0]*)(\\p{XDigit}+);");
    private static final Pattern ESCAPED_PATTERN2 = Pattern.compile("(.)&#([x]*)([0]*)(\\p{XDigit}+);");
    private static final Pattern ESCAPED_PATTERN3 = Pattern.compile("&#([x]*)([0]*)(\\p{XDigit}+);");
    private static final Pattern ESCAPED_PATTERN4 = Pattern.compile("&(\\w+);");

    @Override
    public String format(String text) {
        String result = Objects.requireNonNull(text);
        if (result.isEmpty()) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        result = result.replaceAll("<[ ]?sup>([^<]+)</sup>", "\\\\textsuperscript\\{$1\\}");
        result = result.replaceAll("<[ ]?sub>([^<]+)</sub>", "\\\\textsubscript\\{$1\\}");
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (c == '<') {
                i = this.readTag(result, i);
                continue;
            }
            sb.append(c);
        }
        result = sb.toString();
        Set<String> patterns = HTMLUnicodeConversionMaps.HTML_LATEX_CONVERSION_MAP.keySet();
        for (String pattern : patterns) {
            result = result.replace(pattern, HTMLUnicodeConversionMaps.HTML_LATEX_CONVERSION_MAP.get(pattern));
        }
        Matcher m3 = ESCAPED_PATTERN.matcher(result);
        while (m3.find()) {
            int num = Integer.decode(m3.group(1).replace("x", "#") + m3.group(3));
            if (!HTMLUnicodeConversionMaps.NUMERICAL_LATEX_CONVERSION_MAP.containsKey(num)) continue;
            result = result.replace("&#" + m3.group(1) + m3.group(2) + m3.group(3) + ";", HTMLUnicodeConversionMaps.NUMERICAL_LATEX_CONVERSION_MAP.get(num));
        }
        m3 = ESCAPED_PATTERN2.matcher(result);
        while (m3.find()) {
            int num = Integer.decode(m3.group(2).replace("x", "#") + m3.group(4));
            if (!HTMLUnicodeConversionMaps.ESCAPED_ACCENTS.containsKey(num)) continue;
            if ("i".equals(m3.group(1))) {
                result = result.replace(m3.group(1) + "&#" + m3.group(2) + m3.group(3) + m3.group(4) + ";", "{\\" + HTMLUnicodeConversionMaps.ESCAPED_ACCENTS.get(num) + "{\\i}}");
                continue;
            }
            if ("j".equals(m3.group(1))) {
                result = result.replace(m3.group(1) + "&#" + m3.group(2) + m3.group(3) + m3.group(4) + ";", "{\\" + HTMLUnicodeConversionMaps.ESCAPED_ACCENTS.get(num) + "{\\j}}");
                continue;
            }
            result = result.replace(m3.group(1) + "&#" + m3.group(2) + m3.group(3) + m3.group(4) + ";", "{\\" + HTMLUnicodeConversionMaps.ESCAPED_ACCENTS.get(num) + "{" + m3.group(1) + "}}");
        }
        m3 = ESCAPED_PATTERN3.matcher(result);
        while (m3.find()) {
            int num = Integer.decode(m3.group(1).replace("x", "#") + m3.group(3));
            LOGGER.warn("HTML escaped char not converted: " + m3.group(1) + m3.group(2) + m3.group(3) + " = " + Integer.toString(num));
        }
        result = result.replace("$$", "");
        m3 = ESCAPED_PATTERN4.matcher(result);
        while (m3.find()) {
            LOGGER.warn("HTML escaped char not converted: " + m3.group(1));
        }
        return result.trim();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Converts HTML code to LaTeX code.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "<strong>JabRef</strong>";
    }

    private int readTag(String text, int position) {
        int index = text.indexOf(62, position);
        if (index > position && index - position < 100) {
            return index;
        }
        return position;
    }

    @Override
    public String getName() {
        return Localization.lang("HTML to LaTeX", new String[0]);
    }

    @Override
    public String getKey() {
        return "html_to_latex";
    }
}

