/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jabref.architecture.ApacheCommonsLang3Allowed;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.model.cleanup.Formatter;

@ApacheCommonsLang3Allowed(value="There is no equivalent in Google's Guava")
public class HtmlToUnicodeFormatter
extends Formatter
implements LayoutFormatter {
    @Override
    public String getName() {
        return Localization.lang("HTML to Unicode", new String[0]);
    }

    @Override
    public String getKey() {
        return "html_to_unicode";
    }

    @Override
    public String getDescription() {
        return Localization.lang("Converts HTML code to Unicode.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "<b>bread</b> &amp; butter";
    }

    @Override
    public String format(String fieldText) {
        return StringEscapeUtils.unescapeHtml4(fieldText).replaceAll("\\<[^>]*>", "");
    }
}

