/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public final class Word {
    public static final Set<String> SMALLER_WORDS;
    private final char[] chars;
    private final boolean[] protectedChars;

    public Word(char[] chars, boolean[] protectedChars) {
        this.chars = Objects.requireNonNull(chars);
        this.protectedChars = Objects.requireNonNull(protectedChars);
        if (this.chars.length != this.protectedChars.length) {
            throw new IllegalArgumentException("the chars and the protectedChars array must be of same length");
        }
    }

    public void toUpperCase() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = Character.toUpperCase(this.chars[i]);
        }
    }

    public void toLowerCase() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = Character.toLowerCase(this.chars[i]);
        }
    }

    public void toUpperFirst() {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.protectedChars[i]) continue;
            this.chars[i] = i == 0 ? Character.toUpperCase(this.chars[i]) : Character.toLowerCase(this.chars[i]);
        }
    }

    public boolean isSmallerWord() {
        return SMALLER_WORDS.contains(this.toString().replace(":", "").toLowerCase(Locale.ROOT));
    }

    public boolean isLargerWord() {
        return !this.isSmallerWord();
    }

    public String toString() {
        return new String(this.chars);
    }

    public boolean endsWithColon() {
        return this.toString().endsWith(":");
    }

    static {
        HashSet<String> smallerWords = new HashSet<String>();
        smallerWords.addAll(Arrays.asList("a", "an", "the"));
        smallerWords.addAll(Arrays.asList("above", "about", "across", "against", "along", "among", "around", "at", "before", "behind", "below", "beneath", "beside", "between", "beyond", "by", "down", "during", "except", "for", "from", "in", "inside", "into", "like", "near", "of", "off", "on", "onto", "since", "to", "toward", "through", "under", "until", "up", "upon", "with", "within", "without"));
        smallerWords.addAll(Arrays.asList("and", "but", "for", "nor", "or", "so", "yet"));
        SMALLER_WORDS = Collections.unmodifiableSet(smallerWords);
    }
}

