/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.model.entry.BibEntry;

public interface EntryBasedParserFetcher
extends EntryBasedFetcher {
    public URL getURLForEntry(BibEntry var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    default public void doPostCleanup(BibEntry entry) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Objects.requireNonNull(entry);
        try (BufferedInputStream stream = new BufferedInputStream(this.getURLForEntry(entry).openStream());){
            List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
            fetchedEntries.forEach(this::doPostCleanup);
            List<BibEntry> list = fetchedEntries;
            return list;
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("An I/O exception occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

