/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.client.utils.URIBuilder;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizePagesFormatter;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.fetcher.AbstractIsbnFetcher;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.entry.BibEntry;

public class IsbnViaEbookDeFetcher
extends AbstractIsbnFetcher {
    private static final String BASE_URL = "http://www.ebook.de/de/tools/isbn2bibtex";

    public IsbnViaEbookDeFetcher(ImportFormatPreferences importFormatPreferences) {
        super(importFormatPreferences);
    }

    @Override
    public String getName() {
        return "ISBN (ebook.de)";
    }

    @Override
    public URL getURLForID(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        this.ensureThatIsbnIsValid(identifier);
        URIBuilder uriBuilder = new URIBuilder(BASE_URL);
        uriBuilder.addParameter("isbn", identifier);
        return uriBuilder.build().toURL();
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        entry.getField("pagetotal").ifPresent(pages -> entry.setField("pagetotal", pages.replaceAll("[\\D]", "")));
        new FieldFormatterCleanup("pagetotal", new NormalizePagesFormatter()).cleanup(entry);
        new FieldFormatterCleanup("author", new NormalizeNamesFormatter()).cleanup(entry);
    }
}

