/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.mods.AbstractDefinition;
import org.jabref.logic.importer.fileformat.mods.DateDefinition;
import org.jabref.logic.importer.fileformat.mods.DetailDefinition;
import org.jabref.logic.importer.fileformat.mods.ExtentDefinition;
import org.jabref.logic.importer.fileformat.mods.GenreDefinition;
import org.jabref.logic.importer.fileformat.mods.HierarchicalGeographicDefinition;
import org.jabref.logic.importer.fileformat.mods.IdentifierDefinition;
import org.jabref.logic.importer.fileformat.mods.IssuanceDefinition;
import org.jabref.logic.importer.fileformat.mods.LanguageDefinition;
import org.jabref.logic.importer.fileformat.mods.LanguageTermDefinition;
import org.jabref.logic.importer.fileformat.mods.LocationDefinition;
import org.jabref.logic.importer.fileformat.mods.ModsCollectionDefinition;
import org.jabref.logic.importer.fileformat.mods.ModsDefinition;
import org.jabref.logic.importer.fileformat.mods.NameDefinition;
import org.jabref.logic.importer.fileformat.mods.NamePartDefinition;
import org.jabref.logic.importer.fileformat.mods.NoteDefinition;
import org.jabref.logic.importer.fileformat.mods.OriginInfoDefinition;
import org.jabref.logic.importer.fileformat.mods.PartDefinition;
import org.jabref.logic.importer.fileformat.mods.PlaceDefinition;
import org.jabref.logic.importer.fileformat.mods.RecordInfoDefinition;
import org.jabref.logic.importer.fileformat.mods.RelatedItemDefinition;
import org.jabref.logic.importer.fileformat.mods.StringPlusLanguage;
import org.jabref.logic.importer.fileformat.mods.StringPlusLanguagePlusAuthority;
import org.jabref.logic.importer.fileformat.mods.StringPlusLanguagePlusSupplied;
import org.jabref.logic.importer.fileformat.mods.SubjectDefinition;
import org.jabref.logic.importer.fileformat.mods.TitleInfoDefinition;
import org.jabref.logic.importer.fileformat.mods.UrlDefinition;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsImporter
extends Importer
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModsImporter.class);
    private static final Pattern MODS_PATTERN = Pattern.compile("<mods .*>");
    private final String keywordSeparator;
    private JAXBContext context;

    public ModsImporter(ImportFormatPreferences importFormatPreferences) {
        this.keywordSeparator = importFormatPreferences.getKeywordSeparator() + " ";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        return input.lines().anyMatch(line -> MODS_PATTERN.matcher((CharSequence)line).find());
    }

    @Override
    public ParserResult importDatabase(BufferedReader input) throws IOException {
        Objects.requireNonNull(input);
        ArrayList<BibEntry> bibItems = new ArrayList<BibEntry>();
        try {
            if (this.context == null) {
                this.context = JAXBContext.newInstance((String)"org.jabref.logic.importer.fileformat.mods");
            }
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            JAXBElement unmarshalledObject = (JAXBElement)unmarshaller.unmarshal((Reader)input);
            Optional<ModsCollectionDefinition> collection = this.getElement(unmarshalledObject.getValue(), ModsCollectionDefinition.class);
            Optional<ModsDefinition> mods = this.getElement(unmarshalledObject.getValue(), ModsDefinition.class);
            if (collection.isPresent()) {
                List<ModsDefinition> modsDefinitions = collection.get().getMods();
                this.parseModsCollection(bibItems, modsDefinitions);
            } else if (mods.isPresent()) {
                ModsDefinition modsDefinition = mods.get();
                this.parseMods(bibItems, modsDefinition);
            } else {
                LOGGER.warn("Not expected root element found");
            }
        }
        catch (JAXBException e) {
            LOGGER.debug("could not parse document", e);
            return ParserResult.fromError((Exception)((Object)e));
        }
        return new ParserResult(bibItems);
    }

    private void parseModsCollection(List<BibEntry> bibItems, List<ModsDefinition> mods) {
        for (ModsDefinition modsDefinition : mods) {
            this.parseMods(bibItems, modsDefinition);
        }
    }

    private void parseMods(List<BibEntry> bibItems, ModsDefinition modsDefinition) {
        BibEntry entry = new BibEntry();
        HashMap<String, String> fields = new HashMap<String, String>();
        if (modsDefinition.getID() != null) {
            entry.setCiteKey(modsDefinition.getID());
        }
        if (modsDefinition.getModsGroup() != null) {
            this.parseModsGroup(fields, modsDefinition.getModsGroup(), entry);
        }
        entry.setField(fields);
        bibItems.add(entry);
    }

    private void parseModsGroup(Map<String, String> fields, List<Object> modsGroup, BibEntry entry) {
        ArrayList<String> keywords = new ArrayList<String>();
        ArrayList<String> authors = new ArrayList<String>();
        ArrayList<String> notes = new ArrayList<String>();
        for (Object groupElement : modsGroup) {
            Optional<AbstractDefinition> abstractDefinition = this.getElement(groupElement, AbstractDefinition.class);
            Optional<GenreDefinition> genreDefinition = this.getElement(groupElement, GenreDefinition.class);
            Optional<LanguageDefinition> languageDefinition = this.getElement(groupElement, LanguageDefinition.class);
            Optional<LocationDefinition> locationDefinition = this.getElement(groupElement, LocationDefinition.class);
            Optional<NameDefinition> nameDefinition = this.getElement(groupElement, NameDefinition.class);
            Optional<OriginInfoDefinition> originInfoDefinition = this.getElement(groupElement, OriginInfoDefinition.class);
            Optional<RecordInfoDefinition> recordInfoDefinition = this.getElement(groupElement, RecordInfoDefinition.class);
            Optional<NoteDefinition> noteDefinition = this.getElement(groupElement, NoteDefinition.class);
            Optional<RelatedItemDefinition> relatedItemDefinition = this.getElement(groupElement, RelatedItemDefinition.class);
            Optional<SubjectDefinition> subjectDefinition = this.getElement(groupElement, SubjectDefinition.class);
            Optional<IdentifierDefinition> identifierDefinition = this.getElement(groupElement, IdentifierDefinition.class);
            Optional<TitleInfoDefinition> titleInfoDefinition = this.getElement(groupElement, TitleInfoDefinition.class);
            abstractDefinition.ifPresent(abstractDef -> this.putIfValueNotNull(fields, "abstract", abstractDef.getValue()));
            genreDefinition.ifPresent(genre -> entry.setType(genre.getValue()));
            languageDefinition.ifPresent(languageDef -> languageDef.getLanguageTerm().stream().map(StringPlusLanguage::getValue).forEach(language2 -> this.putIfValueNotNull(fields, "language", (String)language2)));
            locationDefinition.ifPresent(location -> this.parseLocationAndUrl(fields, (LocationDefinition)location));
            nameDefinition.ifPresent(name -> this.handleAuthorsInNamePart((NameDefinition)name, (List<String>)authors, fields));
            originInfoDefinition.ifPresent(originInfo -> originInfo.getPlaceOrPublisherOrDateIssued().stream().forEach(element -> this.putPlaceOrPublisherOrDate(fields, element.getName().getLocalPart(), element.getValue())));
            recordInfoDefinition.ifPresent(recordInfo -> this.parseRecordInfo(fields, (RecordInfoDefinition)recordInfo));
            noteDefinition.ifPresent(note -> notes.add(note.getValue()));
            relatedItemDefinition.ifPresent(relatedItem -> this.parseRelatedModsGroup(fields, relatedItem.getModsGroup()));
            subjectDefinition.ifPresent(subject -> this.parseTopic(fields, subject.getTopicOrGeographicOrTemporal(), keywords));
            identifierDefinition.ifPresent(identifier -> this.parseIdentifier(fields, (IdentifierDefinition)identifier, entry));
            titleInfoDefinition.ifPresent(titleInfo -> this.parseTitle(fields, titleInfo.getTitleOrSubTitleOrPartNumber()));
        }
        this.putIfListIsNotEmpty(fields, keywords, "keywords", this.keywordSeparator);
        this.putIfListIsNotEmpty(fields, authors, "author", " and ");
        this.putIfListIsNotEmpty(fields, notes, "note", ", ");
    }

    private void parseTitle(Map<String, String> fields, List<Object> titleOrSubTitleOrPartNumber) {
        for (Object object : titleOrSubTitleOrPartNumber) {
            JAXBElement element;
            if (!(object instanceof JAXBElement) || !"title".equals((element = (JAXBElement)object).getName().getLocalPart())) continue;
            StringPlusLanguage title = (StringPlusLanguage)element.getValue();
            fields.put("title", title.getValue());
        }
    }

    private void parseIdentifier(Map<String, String> fields, IdentifierDefinition identifier, BibEntry entry) {
        String type = identifier.getType();
        if ("citekey".equals(type) && !entry.getCiteKeyOptional().isPresent()) {
            entry.setCiteKey(identifier.getValue());
        } else if (!"local".equals(type) && !"citekey".equals(type)) {
            this.putIfValueNotNull(fields, identifier.getType(), identifier.getValue());
        }
    }

    private void parseTopic(Map<String, String> fields, List<JAXBElement<?>> topicOrGeographicOrTemporal, List<String> keywords) {
        for (JAXBElement<?> jaxbElement : topicOrGeographicOrTemporal) {
            Object value = jaxbElement.getValue();
            String elementName = jaxbElement.getName().getLocalPart();
            if (value instanceof HierarchicalGeographicDefinition) {
                HierarchicalGeographicDefinition hierarchichalGeographic = (HierarchicalGeographicDefinition)value;
                this.parseGeographicInformation(fields, hierarchichalGeographic);
                continue;
            }
            if (!(value instanceof StringPlusLanguagePlusAuthority) || !"topic".equals(elementName)) continue;
            StringPlusLanguagePlusAuthority topic = (StringPlusLanguagePlusAuthority)value;
            keywords.add(topic.getValue().trim());
        }
    }

    private <T> Optional<T> getElement(Object groupElement, Class<T> clazz) {
        if (clazz.isAssignableFrom(groupElement.getClass())) {
            return Optional.of(clazz.cast(groupElement));
        }
        return Optional.empty();
    }

    private void parseGeographicInformation(Map<String, String> fields, HierarchicalGeographicDefinition hierarchichalGeographic) {
        List<JAXBElement<? extends StringPlusLanguage>> areaOrContinentOrCountry = hierarchichalGeographic.getExtraTerrestrialAreaOrContinentOrCountry();
        for (JAXBElement<? extends StringPlusLanguage> element : areaOrContinentOrCountry) {
            String localName = element.getName().getLocalPart();
            if ("city".equals(localName)) {
                StringPlusLanguage city = (StringPlusLanguage)element.getValue();
                this.putIfValueNotNull(fields, "city", city.getValue());
                continue;
            }
            if (!"country".equals(localName)) continue;
            StringPlusLanguage country = (StringPlusLanguage)element.getValue();
            this.putIfValueNotNull(fields, "country", country.getValue());
        }
    }

    private void parseLocationAndUrl(Map<String, String> fields, LocationDefinition locationDefinition) {
        List<String> locations = locationDefinition.getPhysicalLocation().stream().map(StringPlusLanguage::getValue).collect(Collectors.toList());
        this.putIfListIsNotEmpty(fields, locations, "location", ", ");
        List<String> urls = locationDefinition.getUrl().stream().map(UrlDefinition::getValue).collect(Collectors.toList());
        this.putIfListIsNotEmpty(fields, urls, "url", ", ");
    }

    private void parseRecordInfo(Map<String, String> fields, RecordInfoDefinition recordInfo) {
        List<JAXBElement<?>> recordContent = recordInfo.getRecordContentSourceOrRecordCreationDateOrRecordChangeDate();
        for (JAXBElement<?> jaxbElement : recordContent) {
            Object value = jaxbElement.getValue();
            if (value instanceof StringPlusLanguagePlusAuthority) {
                StringPlusLanguagePlusAuthority source = (StringPlusLanguagePlusAuthority)value;
                this.putIfValueNotNull(fields, "source", source.getValue());
                continue;
            }
            if (!(value instanceof LanguageDefinition)) continue;
            LanguageDefinition language2 = (LanguageDefinition)value;
            List<LanguageTermDefinition> languageTerms = language2.getLanguageTerm();
            List<String> languages = languageTerms.stream().map(StringPlusLanguage::getValue).collect(Collectors.toList());
            this.putIfListIsNotEmpty(fields, languages, "language", ", ");
        }
    }

    private void parseRelatedModsGroup(Map<String, String> fields, List<Object> relatedModsGroup) {
        for (Object groupElement : relatedModsGroup) {
            if (groupElement instanceof PartDefinition) {
                PartDefinition part = (PartDefinition)groupElement;
                List<Object> detailOrExtentOrDate = part.getDetailOrExtentOrDate();
                for (Object object : detailOrExtentOrDate) {
                    if (object instanceof DetailDefinition) {
                        DetailDefinition detail = (DetailDefinition)object;
                        List<JAXBElement<StringPlusLanguage>> numberOrCaptionOrTitle = detail.getNumberOrCaptionOrTitle();
                        for (JAXBElement<StringPlusLanguage> jaxbElement : numberOrCaptionOrTitle) {
                            StringPlusLanguage value = (StringPlusLanguage)jaxbElement.getValue();
                            this.putIfValueNotNull(fields, detail.getType(), value.getValue());
                        }
                        continue;
                    }
                    if (!(object instanceof ExtentDefinition)) continue;
                    ExtentDefinition extentDefinition = (ExtentDefinition)object;
                    this.putPageInformation(extentDefinition, fields);
                }
                continue;
            }
            if (!(groupElement instanceof TitleInfoDefinition)) continue;
            TitleInfoDefinition titleInfo = (TitleInfoDefinition)groupElement;
            List<Object> titleOrSubTitleOrPartNumber = titleInfo.getTitleOrSubTitleOrPartNumber();
            for (Object object : titleOrSubTitleOrPartNumber) {
                JAXBElement element;
                if (!(object instanceof JAXBElement) || !"title".equals((element = (JAXBElement)object).getName().getLocalPart())) continue;
                StringPlusLanguage journal = (StringPlusLanguage)element.getValue();
                fields.put("journal", journal.getValue());
            }
        }
    }

    private void putPageInformation(ExtentDefinition extentDefinition, Map<String, String> fields) {
        if (extentDefinition.getTotal() != null) {
            this.putIfValueNotNull(fields, "pages", String.valueOf(extentDefinition.getTotal()));
        } else if (extentDefinition.getStart() != null) {
            this.putIfValueNotNull(fields, "pages", extentDefinition.getStart().getValue());
            if (extentDefinition.getEnd() != null) {
                String endPage = extentDefinition.getEnd().getValue();
                String startPage = fields.get("pages");
                fields.put("pages", startPage + "-" + endPage);
            }
        }
    }

    private void putPlaceOrPublisherOrDate(Map<String, String> fields, String elementName, Object object) {
        Optional<IssuanceDefinition> issuanceDefinition = this.getElement(object, IssuanceDefinition.class);
        Optional<PlaceDefinition> placeDefinition = this.getElement(object, PlaceDefinition.class);
        Optional<DateDefinition> dateDefinition = this.getElement(object, DateDefinition.class);
        Optional<StringPlusLanguagePlusSupplied> publisherOrEdition = this.getElement(object, StringPlusLanguagePlusSupplied.class);
        issuanceDefinition.ifPresent(issuance -> this.putIfValueNotNull(fields, "issuance", issuance.value()));
        ArrayList<String> places = new ArrayList<String>();
        placeDefinition.ifPresent(place -> place.getPlaceTerm().stream().filter(placeTerm -> placeTerm.getValue() != null).map(StringPlusLanguage::getValue).forEach(element -> places.add((String)element)));
        this.putIfListIsNotEmpty(fields, places, "address", ", ");
        dateDefinition.ifPresent(date -> this.putDate(fields, elementName, (DateDefinition)date));
        publisherOrEdition.ifPresent(pubOrEd -> this.putPublisherOrEdition(fields, elementName, (StringPlusLanguagePlusSupplied)pubOrEd));
    }

    private void putPublisherOrEdition(Map<String, String> fields, String elementName, StringPlusLanguagePlusSupplied pubOrEd) {
        if ("publisher".equals(elementName)) {
            this.putIfValueNotNull(fields, "publisher", pubOrEd.getValue());
        } else if ("edition".equals(elementName)) {
            this.putIfValueNotNull(fields, "edition", pubOrEd.getValue());
        }
    }

    private void putDate(Map<String, String> fields, String elementName, DateDefinition date) {
        if (date.getValue() != null) {
            switch (elementName) {
                case "dateIssued": {
                    fields.put("year", date.getValue().substring(0, 4));
                    break;
                }
                case "dateCreated": {
                    if (fields.get("year") == null) {
                        fields.put("year", date.getValue().substring(0, 4));
                    }
                    fields.put("created", date.getValue());
                    break;
                }
                case "dateCaptured": {
                    fields.put("captured", date.getValue());
                    break;
                }
                case "dateModified": {
                    fields.put("modified", date.getValue());
                    break;
                }
            }
        }
    }

    private void putIfListIsNotEmpty(Map<String, String> fields, List<String> list, String key, String separator) {
        if (!list.isEmpty()) {
            fields.put(key, Joiner.on(separator).join(list));
        }
    }

    private void handleAuthorsInNamePart(NameDefinition name, List<String> authors, Map<String, String> fields) {
        List<JAXBElement<?>> namePartOrDisplayFormOrAffiliation = name.getNamePartOrDisplayFormOrAffiliation();
        ArrayList<String> foreName = new ArrayList<String>();
        String familyName = "";
        String author = "";
        for (JAXBElement<?> element : namePartOrDisplayFormOrAffiliation) {
            Object value = element.getValue();
            String elementName = element.getName().getLocalPart();
            if (value instanceof NamePartDefinition) {
                NamePartDefinition namePart = (NamePartDefinition)value;
                String type = namePart.getAtType();
                if (type == null && namePart.getValue() != null) {
                    authors.add(namePart.getValue());
                    continue;
                }
                if ("family".equals(type) && namePart.getValue() != null) {
                    if (!foreName.isEmpty() && !familyName.isEmpty()) {
                        author = familyName + ", " + Joiner.on(" ").join(foreName);
                        authors.add(author);
                        foreName.clear();
                    } else if (foreName.isEmpty() && !familyName.isEmpty()) {
                        authors.add(familyName);
                    }
                    familyName = namePart.getValue();
                    continue;
                }
                if (!"given".equals(type) || namePart.getValue() == null) continue;
                foreName.add(namePart.getValue());
                continue;
            }
            if (!(value instanceof StringPlusLanguage) || !"affiliation".equals(elementName)) continue;
            StringPlusLanguage affiliation = (StringPlusLanguage)value;
            this.putIfValueNotNull(fields, "affiliation", affiliation.getValue());
        }
        if (!foreName.isEmpty() && !familyName.isEmpty()) {
            author = familyName + ", " + Joiner.on(" ").join(foreName);
            authors.add(author.trim());
            foreName.clear();
        } else if (foreName.isEmpty() && !familyName.isEmpty()) {
            authors.add(familyName.trim());
        }
    }

    private void putIfValueNotNull(Map<String, String> fields, String modsKey, String value) {
        if (value != null) {
            fields.put(modsKey, value);
        }
    }

    @Override
    public String getName() {
        return "MODS";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.XML;
    }

    @Override
    public String getDescription() {
        return "Importer for the MODS format";
    }

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        try {
            return this.importDatabase(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getDatabase().getEntries();
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), e);
            return Collections.emptyList();
        }
    }
}

