/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import com.google.common.collect.HashBiMap;
import java.util.TreeMap;
import org.jabref.logic.msbib.MSBibEntryType;
import org.jabref.model.entry.BiblatexEntryTypes;
import org.jabref.model.entry.BibtexEntryTypes;

public class MSBibMapping {
    private static final String BIBTEX_PREFIX = "BIBTEX_";
    private static final String MSBIB_PREFIX = "msbib-";
    private static final HashBiMap<String, String> BIBLATEX_TO_MS_BIB = HashBiMap.create();

    private MSBibMapping() {
    }

    public static String getBiblatexEntryType(String msbibType) {
        String defaultType = BibtexEntryTypes.MISC.getName();
        TreeMap<String, String> entryTypeMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        entryTypeMapping.put("Book", BiblatexEntryTypes.BOOK.getName());
        entryTypeMapping.put("BookSection", BiblatexEntryTypes.BOOK.getName());
        entryTypeMapping.put("JournalArticle", BiblatexEntryTypes.ARTICLE.getName());
        entryTypeMapping.put("ArticleInAPeriodical", BiblatexEntryTypes.PERIODICAL.getName());
        entryTypeMapping.put("ConferenceProceedings", BiblatexEntryTypes.INPROCEEDINGS.getName());
        entryTypeMapping.put("Report", BiblatexEntryTypes.TECHREPORT.getName());
        entryTypeMapping.put("Patent", BiblatexEntryTypes.PATENT.getName());
        entryTypeMapping.put("InternetSite", BiblatexEntryTypes.ONLINE.getName());
        return entryTypeMapping.getOrDefault(msbibType, defaultType);
    }

    public static MSBibEntryType getMSBibEntryType(String bibtexType) {
        TreeMap<String, MSBibEntryType> entryTypeMapping = new TreeMap<String, MSBibEntryType>(String.CASE_INSENSITIVE_ORDER);
        entryTypeMapping.put("book", MSBibEntryType.Book);
        entryTypeMapping.put("inbook", MSBibEntryType.BookSection);
        entryTypeMapping.put("booklet", MSBibEntryType.BookSection);
        entryTypeMapping.put("incollection", MSBibEntryType.BookSection);
        entryTypeMapping.put("article", MSBibEntryType.JournalArticle);
        entryTypeMapping.put("inproceedings", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("conference", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("proceedings", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("collection", MSBibEntryType.ConferenceProceedings);
        entryTypeMapping.put("techreport", MSBibEntryType.Report);
        entryTypeMapping.put("manual", MSBibEntryType.Report);
        entryTypeMapping.put("mastersthesis", MSBibEntryType.Report);
        entryTypeMapping.put("phdthesis", MSBibEntryType.Report);
        entryTypeMapping.put("unpublished", MSBibEntryType.Report);
        entryTypeMapping.put("patent", MSBibEntryType.Patent);
        entryTypeMapping.put("misc", MSBibEntryType.Misc);
        entryTypeMapping.put("electronic", MSBibEntryType.ElectronicSource);
        entryTypeMapping.put("online", MSBibEntryType.InternetSite);
        return entryTypeMapping.getOrDefault(bibtexType, MSBibEntryType.Misc);
    }

    public static int getLCID(String language2) {
        return 1033;
    }

    public static String getLanguage(int LCID) {
        return "english";
    }

    public static String getMSBibField(String bibtexFieldName) {
        return BIBLATEX_TO_MS_BIB.get(bibtexFieldName);
    }

    public static String getBibTeXField(String msbibFieldName) {
        return (String)BIBLATEX_TO_MS_BIB.inverse().get(msbibFieldName);
    }

    static {
        BIBLATEX_TO_MS_BIB.put("bibtexkey", "Tag");
        BIBLATEX_TO_MS_BIB.put("title", "Title");
        BIBLATEX_TO_MS_BIB.put("year", "Year");
        BIBLATEX_TO_MS_BIB.put("note", "Comments");
        BIBLATEX_TO_MS_BIB.put("volume", "Volume");
        BIBLATEX_TO_MS_BIB.put("language", "LCID");
        BIBLATEX_TO_MS_BIB.put("edition", "Edition");
        BIBLATEX_TO_MS_BIB.put("publisher", "Publisher");
        BIBLATEX_TO_MS_BIB.put("booktitle", "BookTitle");
        BIBLATEX_TO_MS_BIB.put("shorttitle", "ShortTitle");
        BIBLATEX_TO_MS_BIB.put("note", "Comments");
        BIBLATEX_TO_MS_BIB.put("volumes", "NumberVolumes");
        BIBLATEX_TO_MS_BIB.put("chapter", "ChapterNumber");
        BIBLATEX_TO_MS_BIB.put("issue", "Issue");
        BIBLATEX_TO_MS_BIB.put("school", "Department");
        BIBLATEX_TO_MS_BIB.put("institution", "Institution");
        BIBLATEX_TO_MS_BIB.put("doi", "DOI");
        BIBLATEX_TO_MS_BIB.put("url", "URL");
        BIBLATEX_TO_MS_BIB.put("series", "BIBTEX_Series");
        BIBLATEX_TO_MS_BIB.put("abstract", "BIBTEX_Abstract");
        BIBLATEX_TO_MS_BIB.put("keywords", "BIBTEX_KeyWords");
        BIBLATEX_TO_MS_BIB.put("crossref", "BIBTEX_CrossRef");
        BIBLATEX_TO_MS_BIB.put("howpublished", "BIBTEX_HowPublished");
        BIBLATEX_TO_MS_BIB.put("pubstate", "BIBTEX_Pubstate");
        BIBLATEX_TO_MS_BIB.put("affiliation", "BIBTEX_Affiliation");
        BIBLATEX_TO_MS_BIB.put("contents", "BIBTEX_Contents");
        BIBLATEX_TO_MS_BIB.put("copyright", "BIBTEX_Copyright");
        BIBLATEX_TO_MS_BIB.put("price", "BIBTEX_Price");
        BIBLATEX_TO_MS_BIB.put("size", "BIBTEX_Size");
        BIBLATEX_TO_MS_BIB.put("intype", "BIBTEX_InType");
        BIBLATEX_TO_MS_BIB.put("paper", "BIBTEX_Paper");
        BIBLATEX_TO_MS_BIB.put("key", "BIBTEX_Key");
        BIBLATEX_TO_MS_BIB.put("msbib-periodical", "PeriodicalTitle");
        BIBLATEX_TO_MS_BIB.put("msbib-day", "Day");
        BIBLATEX_TO_MS_BIB.put("msbib-accessed", "Accessed");
        BIBLATEX_TO_MS_BIB.put("msbib-medium", "Medium");
        BIBLATEX_TO_MS_BIB.put("msbib-recordingnumber", "RecordingNumber");
        BIBLATEX_TO_MS_BIB.put("msbib-theater", "Theater");
        BIBLATEX_TO_MS_BIB.put("msbib-distributor", "Distributor");
        BIBLATEX_TO_MS_BIB.put("msbib-broadcaster", "Broadcaster");
        BIBLATEX_TO_MS_BIB.put("msbib-station", "Station");
        BIBLATEX_TO_MS_BIB.put("msbib-type", "Type");
        BIBLATEX_TO_MS_BIB.put("msbib-court", "Court");
        BIBLATEX_TO_MS_BIB.put("msbib-reporter", "Reporter");
        BIBLATEX_TO_MS_BIB.put("msbib-casenumber", "CaseNumber");
        BIBLATEX_TO_MS_BIB.put("msbib-abbreviatedcasenumber", "AbbreviatedCaseNumber");
        BIBLATEX_TO_MS_BIB.put("msbib-productioncompany", "ProductionCompany");
    }
}

