/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice;

import java.util.Arrays;
import java.util.List;

public class OpenOfficePreferences {
    public static final String DEFAULT_WINDOWS_PATH = "C:\\Program Files\\LibreOffice 5";
    public static final String DEFAULT_WIN_EXEC_PATH = "C:\\Program Files\\LibreOffice 5\\program";
    public static final String WINDOWS_EXECUTABLE = "soffice.exe";
    public static final String DEFAULT_OSX_PATH = "/Applications/OpenOffice.org.app";
    public static final String DEFAULT_OSX_EXEC_PATH = "/Applications/OpenOffice.org.app/Contents/MacOS/soffice";
    public static final String OSX_EXECUTABLE = "soffice";
    public static final String DEFAULT_LINUX_PATH = "/usr/lib/libreoffice";
    public static final String DEFAULT_LINUX_EXEC_PATH = "/usr/lib/libreoffice/program/soffice";
    public static final String LINUX_EXECUTABLE = "soffice";
    public static final List<String> OO_JARS = Arrays.asList("unoil.jar", "jurt.jar", "juh.jar", "ridl.jar");
    private String executablePath;
    private String installationPath;
    private Boolean useAllDatabases;
    private Boolean syncWhenCiting;
    private Boolean showPanel;
    private List<String> externalStyles;
    private String currentStyle;
    private String jarsPath;

    public OpenOfficePreferences(String jarsPath, String executablePath, String installationPath, Boolean useAllDatabases, Boolean syncWhenCiting, Boolean showPanel, List<String> externalStyles, String currentStyle) {
        this.jarsPath = jarsPath;
        this.executablePath = executablePath;
        this.installationPath = installationPath;
        this.useAllDatabases = useAllDatabases;
        this.syncWhenCiting = syncWhenCiting;
        this.showPanel = showPanel;
        this.externalStyles = externalStyles;
        this.currentStyle = currentStyle;
    }

    public void clearCurrentStyle() {
        this.currentStyle = null;
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    public void setInstallationPath(String installationPath) {
        this.installationPath = installationPath;
    }

    public Boolean getUseAllDatabases() {
        return this.useAllDatabases;
    }

    public void setUseAllDatabases(Boolean useAllDatabases) {
        this.useAllDatabases = useAllDatabases;
    }

    public Boolean getSyncWhenCiting() {
        return this.syncWhenCiting;
    }

    public void setSyncWhenCiting(Boolean syncWhenCiting) {
        this.syncWhenCiting = syncWhenCiting;
    }

    public Boolean getShowPanel() {
        return this.showPanel;
    }

    public void setShowPanel(Boolean showPanel) {
        this.showPanel = showPanel;
    }

    public List<String> getExternalStyles() {
        return this.externalStyles;
    }

    public void setExternalStyles(List<String> externalStyles) {
        this.externalStyles = externalStyles;
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    public void setCurrentStyle(String currentStyle) {
        this.currentStyle = currentStyle;
    }

    public String getJarsPath() {
        return this.jarsPath;
    }

    public void setJarsPath(String jarsPath) {
        this.jarsPath = jarsPath;
    }

    public void updateConnectionParams(String ooPath, String execPath, String jarsPath) {
        this.setInstallationPath(ooPath);
        this.setExecutablePath(execPath);
        this.setJarsPath(jarsPath);
    }

    public void clearConnectionSettings() {
        this.installationPath = null;
        this.executablePath = null;
        this.jarsPath = null;
    }
}

