/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.specialfields;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.util.UpdateField;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.specialfields.SpecialField;

@Deprecated
public class SpecialFieldsUtils {
    public static List<FieldChange> updateField(SpecialField field2, String value, BibEntry entry, boolean nullFieldIfValueIsTheSame, boolean isKeywordSyncEnabled, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        UpdateField.updateField(entry, field2.getFieldName(), value, nullFieldIfValueIsTheSame).ifPresent(fieldChange -> fieldChanges.add((FieldChange)fieldChange));
        if (isKeywordSyncEnabled) {
            fieldChanges.addAll(SpecialFieldsUtils.exportFieldToKeywords(field2, entry, keywordDelimiter));
        }
        return fieldChanges;
    }

    private static List<FieldChange> exportFieldToKeywords(SpecialField specialField, BibEntry entry, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        KeywordList keyWords = specialField.getKeyWords();
        Optional<Keyword> newValue = entry.getField(specialField.getFieldName()).map(Keyword::new);
        newValue.map(value -> entry.replaceKeywords(keyWords, (Keyword)newValue.get(), keywordDelimiter)).orElseGet(() -> entry.removeKeywords(keyWords, keywordDelimiter)).ifPresent(changeValue -> fieldChanges.add((FieldChange)changeValue));
        return fieldChanges;
    }

    public static List<FieldChange> syncKeywordsFromSpecialFields(BibEntry entry, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        for (SpecialField field2 : SpecialField.values()) {
            fieldChanges.addAll(SpecialFieldsUtils.exportFieldToKeywords(field2, entry, keywordDelimiter));
        }
        return fieldChanges;
    }

    private static List<FieldChange> importKeywordsForField(KeywordList keywordList, SpecialField field2, BibEntry entry) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        KeywordList values = field2.getKeyWords();
        Optional<Keyword> newValue = Optional.empty();
        for (Keyword keyword : values) {
            if (!keywordList.contains(keyword)) continue;
            newValue = Optional.of(keyword);
            break;
        }
        UpdateField.updateNonDisplayableField(entry, field2.getFieldName(), newValue.map(Keyword::toString).orElse(null)).ifPresent(fieldChange -> fieldChanges.add((FieldChange)fieldChange));
        return fieldChanges;
    }

    public static List<FieldChange> syncSpecialFieldsFromKeywords(BibEntry entry, Character keywordDelimiter) {
        ArrayList<FieldChange> fieldChanges = new ArrayList<FieldChange>();
        if (!entry.hasField("keywords")) {
            return fieldChanges;
        }
        KeywordList keywordList = entry.getKeywords(keywordDelimiter);
        for (SpecialField field2 : SpecialField.values()) {
            fieldChanges.addAll(SpecialFieldsUtils.importKeywordsForField(keywordList, field2, entry));
        }
        return fieldChanges;
    }

    public static void synchronizeSpecialFields(KeywordList keywordsToAdd, KeywordList keywordsToRemove) {
        KeywordList clone = keywordsToAdd.createClone();
        for (SpecialField field2 : SpecialField.values()) {
            clone.retainAll(field2.getKeyWords());
            if (clone.isEmpty()) continue;
            keywordsToRemove.addAll(field2.getKeyWords());
        }
    }
}

