/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.RandomAccess;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtil.class);

    private XMLUtil() {
    }

    public static void printDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, result);
            System.out.println(writer);
        }
        catch (TransformerException ex) {
            LOGGER.error("", ex);
        }
    }

    public static List<Node> asList(NodeList n) {
        return n.getLength() == 0 ? Collections.emptyList() : new NodeListWrapper(n);
    }

    public static Optional<String> getNodeContent(Node item, String nodeName) {
        if (item.getNodeType() != 1) {
            return Optional.empty();
        }
        NodeList metadata = ((Element)item).getElementsByTagName(nodeName);
        if (metadata.getLength() == 1) {
            return Optional.ofNullable(metadata.item(0).getTextContent());
        }
        return Optional.empty();
    }

    public static Optional<String> getAttributeContent(Node item, String attributeName) {
        NamedNodeMap attributes = item.getAttributes();
        return Optional.ofNullable(attributes.getNamedItem(attributeName)).map(Node::getTextContent);
    }

    public static List<Node> getNodesByName(Node item, String nodeName) {
        if (item.getNodeType() != 1) {
            return Collections.emptyList();
        }
        NodeList nodes = ((Element)item).getElementsByTagName(nodeName);
        return XMLUtil.asList(nodes);
    }

    public static Optional<Node> getNode(Node item, String nodeName) {
        return XMLUtil.getNodesByName(item, nodeName).stream().findFirst();
    }

    private static final class NodeListWrapper
    extends AbstractList<Node>
    implements RandomAccess {
        private final NodeList list;

        NodeListWrapper(NodeList list) {
            this.list = list;
        }

        @Override
        public Node get(int index) {
            return this.list.item(index);
        }

        @Override
        public int size() {
            return this.list.getLength();
        }
    }
}

