/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.jabref.model.entry.BibEntry;

public class CanonicalBibtexEntry {
    private CanonicalBibtexEntry() {
    }

    public static String getCanonicalRepresentation(BibEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(entry.getUserComments());
        String citeKey = entry.getCiteKeyOptional().orElse("");
        sb.append(String.format("@%s{%s,", entry.getType().toLowerCase(Locale.US), citeKey)).append('\n');
        HashMap<String, String> mapFieldToValue = new HashMap<String, String>();
        TreeSet<String> sortedFields = new TreeSet<String>();
        for (Map.Entry<String, String> field2 : entry.getFieldMap().entrySet()) {
            String fieldName = field2.getKey();
            String fieldValue = field2.getValue();
            if (fieldName.equals("bibtexkey")) continue;
            String lowerCaseFieldName = fieldName.toLowerCase(Locale.US);
            sortedFields.add(lowerCaseFieldName);
            mapFieldToValue.put(lowerCaseFieldName, fieldValue);
        }
        StringJoiner sj = new StringJoiner(",\n", "", "\n");
        for (String fieldName : sortedFields) {
            String line = String.format("  %s = {%s}", fieldName, String.valueOf(mapFieldToValue.get(fieldName)).replaceAll("\\r\\n", "\n"));
            sj.add(line);
        }
        sb.append(sj);
        sb.append('}');
        return sb.toString();
    }
}

