/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.entry.Month;

public class Date {
    private final TemporalAccessor date;

    public Date(int year, int month, int dayOfMonth) {
        this(LocalDate.of(year, month, dayOfMonth));
    }

    public Date(int year, int month) {
        this(YearMonth.of(year, month));
    }

    public Date(int year) {
        this(Year.of(year));
    }

    public Date(TemporalAccessor date) {
        this.date = date;
    }

    public static Optional<Date> parse(String dateString) {
        Objects.requireNonNull(dateString);
        List<String> formatStrings = Arrays.asList("uuuu-M-d", "uuuu-M", "d-M-uuuu", "M-uuuu", "M/uu", "M/uuuu", "MMMM d, uuuu", "MMMM, uuuu", "d.M.uuuu", "uuuu.M.d", "uuuu");
        for (String formatString : formatStrings) {
            try {
                TemporalAccessor parsedDate = DateTimeFormatter.ofPattern(formatString).parse(dateString);
                return Optional.of(new Date(parsedDate));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return Optional.empty();
    }

    public static Optional<Date> parse(Optional<String> yearValue, Optional<String> monthValue, Optional<String> dayValue) {
        Optional<Year> year = yearValue.flatMap(Date::convertToInt).map(Year::of);
        Optional month = monthValue.flatMap(Month::parse);
        Optional day = dayValue.flatMap(Date::convertToInt);
        if (year.isPresent()) {
            Object date = month.isPresent() ? (day.isPresent() ? LocalDate.of(year.get().getValue(), ((Month)((Object)month.get())).getNumber(), (int)((Integer)day.get())) : YearMonth.of(year.get().getValue(), ((Month)((Object)month.get())).getNumber())) : (TemporalAccessor)year.get();
            return Optional.of(new Date((TemporalAccessor)date));
        }
        return Optional.empty();
    }

    private static Optional<Integer> convertToInt(String value) {
        try {
            return Optional.of(Integer.valueOf(value));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public String getNormalized() {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("uuuu[-MM][-dd]");
        return dateFormatter.format(this.date);
    }

    public Optional<Integer> getYear() {
        return this.get(ChronoField.YEAR);
    }

    public Optional<Integer> get(ChronoField field2) {
        if (this.date.isSupported(field2)) {
            return Optional.of(this.date.get(field2));
        }
        return Optional.empty();
    }

    public Optional<Month> getMonth() {
        return this.get(ChronoField.MONTH_OF_YEAR).flatMap(Month::getMonthByNumber);
    }

    public Optional<Integer> getDay() {
        return this.get(ChronoField.DAY_OF_MONTH);
    }

    public TemporalAccessor toTemporalAccessor() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Date date1 = (Date)o;
        return Objects.equals(this.getYear(), date1.getYear()) && Objects.equals(this.getMonth(), date1.getMonth()) && Objects.equals(this.getDay(), date1.getDay());
    }

    public String toString() {
        return "Date{date=" + this.date + '}';
    }

    public int hashCode() {
        return Objects.hash(this.date);
    }
}

