/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.entry.identifier.Identifier;

public class ArXivIdentifier
implements Identifier {
    private final String identifier;

    ArXivIdentifier(String identifier) {
        this.identifier = Objects.requireNonNull(identifier).trim();
    }

    public static Optional<ArXivIdentifier> parse(String value) {
        String identifier = value.replaceAll("(?i)arxiv:", "");
        return Optional.of(new ArXivIdentifier(identifier));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArXivIdentifier that = (ArXivIdentifier)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public String getDefaultField() {
        return "eprint";
    }

    @Override
    public String getNormalized() {
        return this.identifier;
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            return Optional.of(new URI("https://arxiv.org/abs/" + this.identifier));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }
}

