/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import com.google.common.eventbus.EventBus;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import org.jabref.model.bibtexkeypattern.DatabaseBibtexKeyPattern;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.model.cleanup.FieldFormatterCleanups;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.database.event.ChangePropagation;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.event.GroupUpdatedEvent;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.SaveOrderConfig;
import org.jabref.model.metadata.event.MetaDataChangedEvent;

public class MetaData {
    public static final String META_FLAG = "jabref-meta: ";
    public static final String SAVE_ORDER_CONFIG = "saveOrderConfig";
    public static final String SAVE_ACTIONS = "saveActions";
    public static final String PREFIX_KEYPATTERN = "keypattern_";
    public static final String KEYPATTERNDEFAULT = "keypatterndefault";
    public static final String DATABASE_TYPE = "databaseType";
    public static final String GROUPSTREE = "grouping";
    public static final String GROUPSTREE_LEGACY = "groupstree";
    public static final String FILE_DIRECTORY = "fileDirectory";
    public static final String PROTECTED_FLAG_META = "protectedFlag";
    public static final String SELECTOR_META_PREFIX = "selector_";
    public static final char ESCAPE_CHARACTER = '\\';
    public static final char SEPARATOR_CHARACTER = ';';
    public static final String SEPARATOR_STRING = String.valueOf(';');
    private final EventBus eventBus = new EventBus();
    private final Map<String, String> citeKeyPatterns = new HashMap<String, String>();
    private final Map<String, String> userFileDirectory = new HashMap<String, String>();
    private GroupTreeNode groupsRoot;
    private Charset encoding;
    private SaveOrderConfig saveOrderConfig;
    private String defaultCiteKeyPattern;
    private FieldFormatterCleanups saveActions;
    private BibDatabaseMode mode;
    private boolean isProtected;
    private String defaultFileDirectory;
    private ContentSelectors contentSelectors = new ContentSelectors();
    private Map<String, List<String>> unkownMetaData = new HashMap<String, List<String>>();
    private boolean isEventPropagationEnabled = true;

    public Optional<SaveOrderConfig> getSaveOrderConfig() {
        return Optional.ofNullable(this.saveOrderConfig);
    }

    public void setSaveOrderConfig(SaveOrderConfig saveOrderConfig) {
        this.saveOrderConfig = saveOrderConfig;
        this.postChange();
    }

    public Optional<GroupTreeNode> getGroups() {
        return Optional.ofNullable(this.groupsRoot);
    }

    public void setGroups(GroupTreeNode root) {
        this.groupsRoot = Objects.requireNonNull(root);
        this.groupsRoot.subscribeToDescendantChanged(groupTreeNode -> this.eventBus.post(new GroupUpdatedEvent(this)));
        this.eventBus.post(new GroupUpdatedEvent(this));
        this.postChange();
    }

    public AbstractBibtexKeyPattern getCiteKeyPattern(GlobalBibtexKeyPattern globalPattern) {
        Objects.requireNonNull(globalPattern);
        DatabaseBibtexKeyPattern bibtexKeyPattern = new DatabaseBibtexKeyPattern(globalPattern);
        this.citeKeyPatterns.forEach(bibtexKeyPattern::addBibtexKeyPattern);
        this.getDefaultCiteKeyPattern().ifPresent(bibtexKeyPattern::setDefaultValue);
        return bibtexKeyPattern;
    }

    public void setCiteKeyPattern(AbstractBibtexKeyPattern bibtexKeyPattern) {
        Objects.requireNonNull(bibtexKeyPattern);
        List<String> defaultValue = bibtexKeyPattern.getDefaultValue();
        Map<String, List<String>> nonDefaultPatterns = bibtexKeyPattern.getPatterns();
        this.setCiteKeyPattern(defaultValue, nonDefaultPatterns);
    }

    public void setCiteKeyPattern(List<String> defaultValue, Map<String, List<String>> nonDefaultPatterns) {
        this.citeKeyPatterns.clear();
        for (Map.Entry<String, List<String>> pattern : nonDefaultPatterns.entrySet()) {
            this.citeKeyPatterns.put(pattern.getKey(), pattern.getValue().get(0));
        }
        this.defaultCiteKeyPattern = defaultValue.isEmpty() ? null : defaultValue.get(0);
        this.postChange();
    }

    public Optional<FieldFormatterCleanups> getSaveActions() {
        return Optional.ofNullable(this.saveActions);
    }

    public void setSaveActions(FieldFormatterCleanups saveActions) {
        this.saveActions = Objects.requireNonNull(saveActions);
        this.postChange();
    }

    public Optional<BibDatabaseMode> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public void setMode(BibDatabaseMode mode) {
        this.mode = Objects.requireNonNull(mode);
        this.postChange();
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public ContentSelectors getContentSelectors() {
        return this.contentSelectors;
    }

    public List<ContentSelector> getContentSelectorList() {
        return this.contentSelectors.getContentSelectors();
    }

    public void addContentSelector(ContentSelector contentSelector) {
        this.contentSelectors.addContentSelector(contentSelector);
        this.postChange();
    }

    public void clearContentSelectors(String fieldName) {
        this.contentSelectors.removeSelector(fieldName);
        this.postChange();
    }

    public List<String> getContentSelectorValuesForField(String fieldName) {
        return this.contentSelectors.getSelectorValuesForField(fieldName);
    }

    public Optional<String> getDefaultFileDirectory() {
        return Optional.ofNullable(this.defaultFileDirectory);
    }

    public void setDefaultFileDirectory(String path) {
        this.defaultFileDirectory = Objects.requireNonNull(path).trim();
        this.postChange();
    }

    public Optional<String> getUserFileDirectory(String user) {
        return Optional.ofNullable(this.userFileDirectory.get(user));
    }

    public void markAsProtected() {
        this.isProtected = true;
        this.postChange();
    }

    public void clearDefaultFileDirectory() {
        this.defaultFileDirectory = null;
        this.postChange();
    }

    public void setUserFileDirectory(String user, String path) {
        this.userFileDirectory.put(Objects.requireNonNull(user), Objects.requireNonNull(path));
        this.postChange();
    }

    public void clearUserFileDirectory(String user) {
        this.userFileDirectory.remove(user);
        this.postChange();
    }

    public void markAsNotProtected() {
        this.isProtected = false;
        this.postChange();
    }

    public void clearSaveActions() {
        this.saveActions = null;
        this.postChange();
    }

    public void clearSaveOrderConfig() {
        this.saveOrderConfig = null;
        this.postChange();
    }

    private void postChange() {
        if (this.isEventPropagationEnabled) {
            this.eventBus.post(new MetaDataChangedEvent(this));
        }
    }

    public Optional<Charset> getEncoding() {
        return Optional.ofNullable(this.encoding);
    }

    public void setEncoding(Charset encoding) {
        this.setEncoding(encoding, ChangePropagation.POST_EVENT);
    }

    public void setEncoding(Charset encoding, ChangePropagation postChanges) {
        this.encoding = Objects.requireNonNull(encoding);
        if (postChanges == ChangePropagation.POST_EVENT) {
            this.postChange();
        }
    }

    public void setEventPropagation(boolean enabled) {
        this.isEventPropagationEnabled = enabled;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterListener(Object listener) {
        try {
            this.eventBus.unregister(listener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Optional<String> getDefaultCiteKeyPattern() {
        return Optional.ofNullable(this.defaultCiteKeyPattern);
    }

    public boolean isEmpty() {
        return this.equals(new MetaData());
    }

    public Map<String, String> getUserFileDirectories() {
        return Collections.unmodifiableMap(this.userFileDirectory);
    }

    public Map<String, List<String>> getUnknownMetaData() {
        return Collections.unmodifiableMap(this.unkownMetaData);
    }

    public void putUnkownMetaDataItem(String key, List<String> value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.unkownMetaData.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        return this.isProtected == metaData.isProtected && Objects.equals(this.groupsRoot, metaData.groupsRoot) && Objects.equals(this.encoding, metaData.encoding) && Objects.equals(this.saveOrderConfig, metaData.saveOrderConfig) && Objects.equals(this.citeKeyPatterns, metaData.citeKeyPatterns) && Objects.equals(this.userFileDirectory, metaData.userFileDirectory) && Objects.equals(this.defaultCiteKeyPattern, metaData.defaultCiteKeyPattern) && Objects.equals(this.saveActions, metaData.saveActions) && this.mode == metaData.mode && Objects.equals(this.defaultFileDirectory, metaData.defaultFileDirectory) && Objects.equals(this.contentSelectors, metaData.contentSelectors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupsRoot, this.encoding, this.saveOrderConfig, this.citeKeyPatterns, this.userFileDirectory, this.defaultCiteKeyPattern, this.saveActions, this.mode, this.isProtected, this.defaultFileDirectory});
    }
}

