/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.regex.Pattern;
import org.jabref.model.search.rules.ContainBasedSearchRule;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.search.rules.RegexBasedSearchRule;
import org.jabref.model.search.rules.SearchRule;

public class SearchRules {
    private static final Pattern SIMPLE_EXPRESSION = Pattern.compile("[^\\p{Punct}]*");

    private SearchRules() {
    }

    public static SearchRule getSearchRuleByQuery(String query, boolean caseSensitive, boolean regex) {
        if (SearchRules.isSimpleQuery(query)) {
            return new ContainBasedSearchRule(caseSensitive);
        }
        GrammarBasedSearchRule searchExpression = new GrammarBasedSearchRule(caseSensitive, regex);
        if (searchExpression.validateSearchStrings(query)) {
            return searchExpression;
        }
        return SearchRules.getSearchRule(caseSensitive, regex);
    }

    private static boolean isSimpleQuery(String query) {
        return SIMPLE_EXPRESSION.matcher(query).matches();
    }

    private static SearchRule getSearchRule(boolean caseSensitive, boolean regex) {
        if (regex) {
            return new RegexBasedSearchRule(caseSensitive);
        }
        return new ContainBasedSearchRule(caseSensitive);
    }
}

