/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.lang;

import com.sun.electric.tool.Job;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class EvalSpice {
    private String expr;
    private StreamTokenizer tokenizer;
    int openParens;
    private static final Double ONE = new Double(1.0);
    private static final Double ZERO = new Double(0.0);

    public EvalSpice(String expr) {
        this.expr = expr;
        this.openParens = 0;
    }

    public Object evaluate() {
        if (this.expr == null) {
            return null;
        }
        StringReader reader = new StringReader(this.expr);
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.ordinaryChar(40);
        this.tokenizer.ordinaryChar(41);
        this.tokenizer.ordinaryChar(42);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.ordinaryChar(43);
        this.tokenizer.ordinaryChar(45);
        this.tokenizer.ordinaryChar(60);
        this.tokenizer.ordinaryChar(61);
        this.tokenizer.ordinaryChar(62);
        this.tokenizer.ordinaryChar(33);
        this.tokenizer.ordinaryChar(63);
        this.tokenizer.ordinaryChar(58);
        this.tokenizer.wordChars(95, 95);
        try {
            return this.evalEq().eval();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (ParseException e) {
            String parsed = "";
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            try {
                long left = reader.skip(Long.MAX_VALUE);
                parsed = this.expr.substring(0, this.expr.length() - (int)left);
            }
            catch (IOException e2) {
                // empty catch block
            }
            if (!parsed.equals("")) {
                parsed = ": " + parsed + " <--";
            }
            System.out.println("Spice Parse Error: " + e.getMessage() + parsed + " " + this.tokenizer.toString());
            System.out.println("   Original string: " + this.expr);
        }
        return this.expr;
    }

    private SimpleEq evalEq() throws IOException, ParseException {
        SimpleEq eq2 = new SimpleEq();
        while (true) {
            int tt;
            if ((tt = this.tokenizer.nextToken()) == -1 || tt == 10) {
                if (this.openParens > 0) {
                    throw new ParseException("Unmatched open parens");
                }
                return eq2;
            }
            if (tt == 41) {
                --this.openParens;
                if (this.openParens < 0) {
                    throw new ParseException("Unmatched close parens");
                }
                Object value = eq2.eval();
                if (value instanceof String) {
                    return new SimpleEq("(" + value.toString() + ")", null, null);
                }
                return new SimpleEq(value, null, null);
            }
            if (tt == 40) {
                ++this.openParens;
                if (!eq2.addIdentifierOk()) {
                    throw new ParseException("Too many identifiers");
                }
                SimpleEq id = this.evalEq();
                eq2.addIdentifier(id);
                continue;
            }
            if (tt == 44) {
                return eq2;
            }
            if (tt == -2) {
                this.tokenizer.pushBack();
                eq2.addIdentifier(this.parseNumber());
                continue;
            }
            if (tt == -3) {
                double b;
                double a;
                Object m2;
                Object m1;
                Object arg;
                if (this.tokenizer.sval.equalsIgnoreCase("sin")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double(Math.sin((Double)arg)) : "sin" + EvalSpice.format(arg);
                    eq2.addIdentifier(arg);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("min")) {
                    this.expect(40);
                    ++this.openParens;
                    m1 = this.evalEq().eval();
                    m2 = this.evalEq().eval();
                    if (m1 instanceof Double && m2 instanceof Double) {
                        a = (Double)m1;
                        b = (Double)m2;
                        m1 = new Double(Math.min(a, b));
                    } else {
                        String m2str = EvalSpice.format(m2);
                        if (m2str.startsWith("(") && m2str.endsWith(")")) {
                            m2str = m2str.substring(1, m2str.length() - 1);
                        }
                        m1 = "min(" + EvalSpice.format(m1) + "," + m2str + ")";
                    }
                    eq2.addIdentifier(m1);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("max")) {
                    this.expect(40);
                    ++this.openParens;
                    m1 = this.evalEq().eval();
                    m2 = this.evalEq().eval();
                    if (m1 instanceof Double && m2 instanceof Double) {
                        a = (Double)m1;
                        b = (Double)m2;
                        m1 = new Double(Math.max(a, b));
                    } else {
                        String m2str = EvalSpice.format(m2);
                        if (m2str.startsWith("(") && m2str.endsWith(")")) {
                            m2str = m2str.substring(1, m2str.length() - 1);
                        }
                        m1 = "max(" + EvalSpice.format(m1) + "," + m2str + ")";
                    }
                    eq2.addIdentifier(m1);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("abs")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double(Math.abs((Double)arg)) : "abs" + EvalSpice.format(arg);
                    eq2.addIdentifier(arg);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("sqrt")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double(Math.sqrt((Double)arg)) : "sqrt" + EvalSpice.format(arg);
                    eq2.addIdentifier(arg);
                    continue;
                }
                if (this.tokenizer.sval.equalsIgnoreCase("int")) {
                    this.expect(40);
                    ++this.openParens;
                    arg = this.evalEq().eval();
                    arg = arg instanceof Double ? new Double((int)((Double)arg).doubleValue()) : "int" + EvalSpice.format(arg);
                    eq2.addIdentifier(arg);
                    continue;
                }
                eq2.addIdentifier(this.tokenizer.sval);
                continue;
            }
            if (tt == 42) {
                eq2.addOp(Op.MULT);
                continue;
            }
            if (tt == 47) {
                eq2.addOp(Op.DIV);
                continue;
            }
            if (tt == 43) {
                eq2.addOp(Op.PLUS);
                continue;
            }
            if (tt == 45) {
                eq2.addOp(Op.MINUS);
                continue;
            }
            if (tt == 60) {
                tt = this.tokenizer.nextToken();
                if (tt == 61) {
                    eq2.addOp(Op.LTOE);
                    continue;
                }
                this.tokenizer.pushBack();
                eq2.addOp(Op.LT);
                continue;
            }
            if (tt == 62) {
                tt = this.tokenizer.nextToken();
                if (tt == 61) {
                    eq2.addOp(Op.GTOE);
                    continue;
                }
                this.tokenizer.pushBack();
                eq2.addOp(Op.GT);
                continue;
            }
            if (tt == 61) {
                this.expect(61);
                eq2.addOp(Op.EQ);
                continue;
            }
            if (tt == 33) {
                this.expect(61);
                eq2.addOp(Op.NE);
                continue;
            }
            if (tt == 63) {
                eq2.addOp(Op.COND);
                continue;
            }
            if (tt != 58) continue;
            eq2.addOp(Op.CONDCHOICE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseNumber() throws IOException, ParseException {
        int tt = this.tokenizer.nextToken();
        if (tt != -2) throw new ParseException("Expected number");
        double val = this.tokenizer.nval;
        this.tokenizer.ordinaryChar(101);
        this.tokenizer.ordinaryChar(69);
        tt = this.tokenizer.nextToken();
        if (tt == 101 || tt == 69) {
            tt = this.tokenizer.nextToken();
            boolean minus2 = false;
            if (tt == 45) {
                minus2 = true;
                tt = this.tokenizer.nextToken();
            }
            if (tt != -2) throw new ParseException("Invalid token");
            double exp = this.tokenizer.nval;
            if (minus2) {
                exp = -1.0 * exp;
            }
            val *= Math.pow(10.0, exp);
        } else if (tt == -3) {
            TextUtils.UnitScale u = TextUtils.UnitScale.findUnitScaleFromPostfix(this.tokenizer.sval);
            if (u == TextUtils.UnitScale.NONE) {
                throw new ParseException("Invalid token");
            }
            val *= u.getMultiplier().doubleValue();
        } else {
            this.tokenizer.pushBack();
        }
        this.tokenizer.wordChars(101, 101);
        this.tokenizer.wordChars(69, 69);
        return new Double(val);
    }

    private void expect(int token) throws IOException, ParseException {
        int tt = this.tokenizer.nextToken();
        if (tt != token) {
            throw new ParseException("Expected token " + token);
        }
    }

    private static String format(Object obj) {
        if (obj instanceof Double) {
            return TextUtils.formatDoublePostFix((Double)obj);
        }
        return obj.toString();
    }

    public static class SimpleEq {
        protected Object lhop;
        private Op op;
        protected Object rhop;
        boolean neglh = false;
        boolean negrh = false;

        public SimpleEq() {
            this.lhop = null;
            this.op = null;
            this.rhop = null;
        }

        public SimpleEq(Object lhop, Op op, Object rhop) {
            this.lhop = lhop;
            this.op = op;
            this.rhop = rhop;
        }

        public boolean addIdentifierOk() {
            if (this.lhop == null) {
                return true;
            }
            if (this.rhop == null && this.op != null) {
                return true;
            }
            if (this.rhop instanceof SimpleEq) {
                return ((SimpleEq)this.rhop).addIdentifierOk();
            }
            return false;
        }

        public void addIdentifier(Object id) throws ParseException {
            if (this.lhop == null) {
                this.lhop = id;
            } else if (this.rhop == null && this.op != null) {
                this.rhop = id;
            } else if (this.rhop instanceof SimpleEq) {
                ((SimpleEq)this.rhop).addIdentifier(id);
            } else {
                throw new ParseException("Two operands with no operator");
            }
        }

        public void addOp(Op operator) throws ParseException {
            if (this.lhop == null && operator == Op.MINUS && !this.neglh) {
                this.neglh = true;
            } else {
                if (this.lhop == null) {
                    throw new ParseException("Operator " + operator + " with no left hand operand");
                }
                if (this.op == null && this.rhop == null) {
                    this.op = operator;
                } else if (this.op != null && this.rhop == null && operator == Op.MINUS && !this.negrh) {
                    this.negrh = true;
                } else if (this.op != null && this.rhop != null) {
                    if (this.rhop instanceof SimpleEq) {
                        ((SimpleEq)this.rhop).addOp(operator);
                    } else if (operator.precedence < this.op.precedence) {
                        this.rhop = new SimpleEq(this.rhop, operator, null);
                        ((SimpleEq)this.rhop).neglh = this.negrh;
                        this.negrh = false;
                    } else {
                        this.lhop = new SimpleEq(this.lhop, this.op, this.rhop);
                        this.op = operator;
                        this.rhop = null;
                        ((SimpleEq)this.lhop).neglh = this.neglh;
                        ((SimpleEq)this.lhop).negrh = this.negrh;
                        this.neglh = false;
                        this.negrh = false;
                    }
                } else {
                    throw new ParseException("Two operators in a row");
                }
            }
        }

        public Object eval() throws ParseException {
            if (this.lhop instanceof SimpleEq) {
                this.lhop = ((SimpleEq)this.lhop).eval();
            }
            if (this.rhop instanceof SimpleEq) {
                this.rhop = ((SimpleEq)this.rhop).eval();
            }
            if (this.op == Op.CONDCHOICE) {
                return this;
            }
            if (this.op == Op.COND && this.rhop instanceof SimpleEq) {
                SimpleEq condval = (SimpleEq)this.rhop;
                if (this.lhop instanceof Double && condval.lhop instanceof Double && condval.rhop instanceof Double) {
                    double cond = (Double)this.lhop;
                    if (this.neglh) {
                        cond = -1.0 * cond;
                    }
                    double valt = (Double)condval.lhop;
                    if (condval.neglh) {
                        valt = -1.0 * valt;
                    }
                    double valf = (Double)condval.rhop;
                    if (condval.negrh) {
                        valf = -1.0 * valf;
                    }
                    if (cond == 0.0) {
                        return valf;
                    }
                    return valt;
                }
                String neglhstr = condval.neglh ? "-" : "";
                String negrhstr = condval.negrh ? "-" : "";
                this.rhop = neglhstr + EvalSpice.format(condval.lhop) + " : " + negrhstr + EvalSpice.format(condval.rhop);
            } else if (this.lhop instanceof Double && this.rhop instanceof Double) {
                double lh = (Double)this.lhop;
                double rh = (Double)this.rhop;
                if (this.neglh) {
                    lh = -1.0 * lh;
                }
                if (this.negrh) {
                    rh = -1.0 * rh;
                }
                if (this.op == Op.MULT) {
                    return new Double(lh * rh);
                }
                if (this.op == Op.DIV) {
                    return new Double(lh / rh);
                }
                if (this.op == Op.PLUS) {
                    return new Double(lh + rh);
                }
                if (this.op == Op.MINUS) {
                    return new Double(lh - rh);
                }
                if (this.op == Op.LT) {
                    return lh < rh ? ONE : ZERO;
                }
                if (this.op == Op.LTOE) {
                    return lh <= rh ? ONE : ZERO;
                }
                if (this.op == Op.GT) {
                    return lh > rh ? ONE : ZERO;
                }
                if (this.op == Op.GTOE) {
                    return lh >= rh ? ONE : ZERO;
                }
                if (this.op == Op.EQ) {
                    return lh == rh ? ONE : ZERO;
                }
                if (this.op == Op.NE) {
                    return lh != rh ? ONE : ZERO;
                }
                if (this.op == Op.LAND) {
                    return lh != 0.0 && rh != 0.0 ? ONE : ZERO;
                }
                if (this.op == Op.LOR) {
                    return lh != 0.0 || rh != 0.0 ? ONE : ZERO;
                }
            } else if (this.op == null && this.rhop == null) {
                if (this.neglh) {
                    if (this.lhop instanceof Double) {
                        return -1.0 * (Double)this.lhop;
                    }
                    return "-" + this.lhop.toString();
                }
                return this.lhop;
            }
            String neglhstr = this.neglh ? "-" : "";
            String negrhstr = this.negrh ? "-" : "";
            String lhstr = this.lhop == null ? "?" : EvalSpice.format(this.lhop);
            String rhstr = this.rhop == null ? "?" : EvalSpice.format(this.rhop);
            return neglhstr + lhstr + " " + this.op + " " + negrhstr + rhstr;
        }
    }

    public static class Op {
        public final String name;
        public final int precedence;
        public static final Op MULT = new Op("*", 2);
        public static final Op DIV = new Op("/", 2);
        public static final Op PLUS = new Op("+", 3);
        public static final Op MINUS = new Op("-", 3);
        public static final Op LT = new Op("<", 5);
        public static final Op LTOE = new Op("<=", 5);
        public static final Op GT = new Op(">", 5);
        public static final Op GTOE = new Op(">=", 5);
        public static final Op EQ = new Op("==", 6);
        public static final Op NE = new Op("!=", 6);
        public static final Op LAND = new Op("&&", 10);
        public static final Op LOR = new Op("||", 11);
        public static final Op CONDCHOICE = new Op(":", 12);
        public static final Op COND = new Op("?", 13);

        private Op(String name, int precedence) {
            this.name = name;
            this.precedence = precedence;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ParseException
    extends Exception {
        public ParseException(String msg) {
            super(msg);
        }
    }
}

