/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class IconParameters
implements Serializable {
    int inputSide = 0;
    int outputSide = 1;
    int bidirSide = 2;
    int pwrSide = 3;
    int gndSide = 3;
    int clkSide = 0;
    int topRot = 0;
    int bottomRot = 0;
    int leftRot = 0;
    int rightRot = 0;
    boolean topSkip = false;
    boolean bottomSkip = false;
    boolean leftSkip = false;
    boolean rightSkip = false;

    public static IconParameters makeInstance(boolean userDefaults) {
        return new IconParameters(userDefaults);
    }

    private IconParameters(boolean userDefaults) {
        if (userDefaults) {
            this.inputSide = User.getIconGenInputSide();
            this.outputSide = User.getIconGenOutputSide();
            this.bidirSide = User.getIconGenBidirSide();
            this.pwrSide = User.getIconGenPowerSide();
            this.gndSide = User.getIconGenGroundSide();
            this.clkSide = User.getIconGenClockSide();
            this.topRot = User.getIconGenTopRot();
            this.bottomRot = User.getIconGenBottomRot();
            this.leftRot = User.getIconGenLeftRot();
            this.rightRot = User.getIconGenRightRot();
            this.topSkip = User.isIconGenTopSkip();
            this.bottomSkip = User.isIconGenBottomSkip();
            this.leftSkip = User.isIconGenLeftSkip();
            this.rightSkip = User.isIconGenRightSkip();
        }
    }

    public Cell makeIconForCell(Cell curCell, EditingPreferences ep) throws JobException {
        double ySize;
        double xSize;
        ShadowExport se;
        boolean schematicSource = curCell.getView() == View.SCHEMATIC;
        String iconCellName = curCell.getName() + "{ic}";
        Cell iconCell = Cell.makeInstance(ep, curCell.getLibrary(), iconCellName);
        if (iconCell == null) {
            throw new JobException("Cannot create Icon cell " + iconCellName);
        }
        iconCell.setWantExpanded();
        ERectangle cellBounds = curCell.getBounds();
        HashMap<String, ShadowExport> shadowExports = new HashMap<String, ShadowExport>();
        Iterator<PortProto> it = curCell.getPorts();
        while (it.hasNext()) {
            ShadowExport se2;
            String indexPart;
            int lastSq;
            Export e = (Export)it.next();
            if (e.isBodyOnly()) continue;
            String name = e.getName();
            if (schematicSource) {
                se = new ShadowExport(name);
                shadowExports.put(name, se);
                se.isBus = e.getNameKey().isBus();
                se.originals.add(e);
                continue;
            }
            Integer index = null;
            int indexPos = name.indexOf(91);
            if (indexPos >= 0 && (lastSq = (indexPart = name.substring(indexPos + 1)).indexOf(93)) == indexPart.length() - 1) {
                int indexVal = TextUtils.atoi(indexPart.substring(0, lastSq));
                index = indexVal;
                name = name.substring(0, indexPos);
            }
            if ((se2 = (ShadowExport)shadowExports.get(name)) == null) {
                se2 = new ShadowExport(name);
                shadowExports.put(name, se2);
            }
            if (index != null) {
                se2.indices.add(index);
            }
            se2.originals.add(e);
        }
        ArrayList<ShadowExport> shadowExportList = new ArrayList<ShadowExport>();
        for (String seName : shadowExports.keySet()) {
            se = (ShadowExport)shadowExports.get(seName);
            double x = 0.0;
            double y = 0.0;
            for (Export e : se.originals) {
                EPoint ctr = e.getOriginalPort().getCenter();
                x += ((Point2D)ctr).getX();
                y += ((Point2D)ctr).getY();
                if (((Point2D)ctr).getX() < cellBounds.getMinX() + cellBounds.getWidth() / 10.0) {
                    se.nearLeft = true;
                }
                if (((Point2D)ctr).getX() > cellBounds.getMaxX() - cellBounds.getWidth() / 10.0) {
                    se.nearRight = true;
                }
                if (((Point2D)ctr).getY() < cellBounds.getMinY() + cellBounds.getHeight() / 10.0) {
                    se.nearBottom = true;
                }
                if (!(((Point2D)ctr).getY() > cellBounds.getMaxY() - cellBounds.getHeight() / 10.0)) continue;
                se.nearTop = true;
            }
            se.center = new Point2D.Double(x / (double)se.originals.size(), y / (double)se.originals.size());
            if (se.indices.size() == 1) {
                se.exportName = se.exportName + "[" + se.indices.get(0) + "]";
            } else if (se.indices.size() > 0) {
                Collections.sort(se.indices);
                String index = "";
                for (int i = 0; i < se.indices.size(); ++i) {
                    int start;
                    int end = start = se.indices.get(i).intValue();
                    for (int j = i + 1; j < se.indices.size() && se.indices.get(j) == end + 1; ++j) {
                        ++end;
                        ++i;
                    }
                    index = start == end ? index + "," + start : index + "," + start + ":" + end;
                }
                se.exportName = se.exportName + "[" + index.substring(1) + "]";
                se.isBus = true;
            }
            shadowExportList.add(se);
        }
        int leftSide = 0;
        int rightSide = 0;
        int bottomSide = 0;
        int topSide = 0;
        HashMap<ShadowExport, Integer> portIndex = new HashMap<ShadowExport, Integer>();
        HashMap<ShadowExport, Integer> portSide = new HashMap<ShadowExport, Integer>();
        HashMap<ShadowExport, Integer> portRotation = new HashMap<ShadowExport, Integer>();
        if (ep.getIconGenExportPlacement() == 1) {
            ShadowExport se3;
            int i;
            int i2;
            Collections.sort(shadowExportList);
            int numExports = shadowExportList.size();
            int numSides = (this.topSkip ? 0 : 1) + (this.bottomSkip ? 0 : 1) + (this.leftSkip ? 0 : 1) + (this.rightSkip ? 0 : 1);
            if (numSides == 0) {
                numSides = 1;
                this.leftSkip = false;
            }
            if (schematicSource) {
                int numOnSide = numExports / numSides;
                topSide = this.topSkip ? 0 : numOnSide;
                bottomSide = this.bottomSkip ? 0 : numOnSide;
                leftSide = this.leftSkip ? 0 : numOnSide;
                rightSide = this.rightSkip ? 0 : numOnSide;
            } else {
                for (ShadowExport se4 : shadowExportList) {
                    if (se4.nearBottom && !this.bottomSkip) {
                        ++bottomSide;
                        continue;
                    }
                    if (se4.nearTop && !this.topSkip) {
                        ++topSide;
                        continue;
                    }
                    if (se4.nearLeft && !this.leftSkip) {
                        ++leftSide;
                        continue;
                    }
                    if (!se4.nearRight || this.rightSkip) continue;
                    ++rightSide;
                }
            }
            int cycle = 0;
            while (leftSide + rightSide + topSide + bottomSide < numExports) {
                switch (cycle) {
                    case 0: {
                        if (this.leftSkip) break;
                        ++leftSide;
                        break;
                    }
                    case 1: {
                        if (this.rightSkip) break;
                        ++rightSide;
                        break;
                    }
                    case 2: {
                        if (this.topSkip) break;
                        ++topSide;
                        break;
                    }
                    case 3: {
                        if (this.bottomSkip) break;
                        ++bottomSide;
                    }
                }
                cycle = (cycle + 1) % 4;
            }
            int[] sides = new int[numExports];
            int fill2 = 0;
            for (i2 = 0; i2 < leftSide; ++i2) {
                sides[fill2++] = 0;
            }
            for (i2 = 0; i2 < topSide; ++i2) {
                sides[fill2++] = 1;
            }
            for (i2 = 0; i2 < rightSide; ++i2) {
                sides[fill2++] = 2;
            }
            for (i2 = 0; i2 < bottomSide; ++i2) {
                sides[fill2++] = 3;
            }
            double[] totDist = new double[numExports];
            for (int i3 = 0; i3 < numExports; ++i3) {
                totDist[i3] = 0.0;
                for (int j = 0; j < numExports; ++j) {
                    Point2D ppCtr = ((ShadowExport)shadowExportList.get((int)((j + i3) % numExports))).center;
                    double dist = 0.0;
                    switch (sides[j]) {
                        case 0: {
                            dist = Math.abs(ppCtr.getX() - cellBounds.getMinX());
                            break;
                        }
                        case 1: {
                            dist = Math.abs(ppCtr.getY() - cellBounds.getMaxY());
                            break;
                        }
                        case 2: {
                            dist = Math.abs(ppCtr.getX() - cellBounds.getMaxX());
                            break;
                        }
                        case 3: {
                            dist = Math.abs(ppCtr.getY() - cellBounds.getMinY());
                        }
                    }
                    int n = i3;
                    totDist[n] = totDist[n] + dist;
                }
            }
            double bestDist = Double.MAX_VALUE;
            int bestIndex = -1;
            for (i = 0; i < numExports; ++i) {
                if (!(totDist[i] < bestDist)) continue;
                bestDist = totDist[i];
                bestIndex = i;
            }
            for (i = 0; i < leftSide; ++i) {
                se3 = (ShadowExport)shadowExportList.get((i + bestIndex) % numExports);
                portSide.put(se3, new Integer(0));
                portIndex.put(se3, new Integer(leftSide - i - 1));
                portRotation.put(se3, new Integer(this.leftRot));
            }
            for (i = 0; i < topSide; ++i) {
                se3 = (ShadowExport)shadowExportList.get((i + leftSide + bestIndex) % numExports);
                portSide.put(se3, new Integer(2));
                portIndex.put(se3, new Integer(topSide - i - 1));
                portRotation.put(se3, new Integer(this.topRot));
            }
            for (i = 0; i < rightSide; ++i) {
                se3 = (ShadowExport)shadowExportList.get((i + leftSide + topSide + bestIndex) % numExports);
                portSide.put(se3, new Integer(1));
                portIndex.put(se3, new Integer(i));
                portRotation.put(se3, new Integer(this.rightRot));
            }
            for (i = 0; i < bottomSide; ++i) {
                se3 = (ShadowExport)shadowExportList.get((i + leftSide + topSide + rightSide + bestIndex) % numExports);
                portSide.put(se3, new Integer(3));
                portIndex.put(se3, new Integer(i));
                portRotation.put(se3, new Integer(this.bottomRot));
            }
        } else {
            Collections.sort(shadowExportList, new ShadowExportByName());
            if (ep.isIconGenReverseExportOrder()) {
                Collections.reverse(shadowExportList);
            }
            for (ShadowExport se5 : shadowExportList) {
                Export e = se5.originals.get(0);
                int index = this.iconPosition(e);
                portSide.put(se5, new Integer(index));
                switch (index) {
                    case 0: {
                        portIndex.put(se5, new Integer(leftSide++));
                        break;
                    }
                    case 1: {
                        portIndex.put(se5, new Integer(rightSide++));
                        break;
                    }
                    case 2: {
                        portIndex.put(se5, new Integer(topSide++));
                        break;
                    }
                    case 3: {
                        portIndex.put(se5, new Integer(bottomSide++));
                    }
                }
                int rotation = ViewChanges.iconTextRotation(e, ep);
                portRotation.put(se5, new Integer(rotation));
            }
        }
        if (ep.getIconGenExportPlacement() == 1 && ep.isIconGenExportPlacementExact()) {
            xSize = curCell.getDefWidth();
            ySize = curCell.getDefHeight();
        } else {
            ySize = (double)Math.max(Math.max(leftSide, rightSide), 5) * ep.getIconGenLeadSpacing();
            xSize = (double)Math.max(Math.max(topSide, bottomSide), 3) * ep.getIconGenLeadSpacing();
        }
        NodeInst bbNi = null;
        if (ep.isIconGenDrawBody()) {
            bbNi = NodeInst.newInstance(Artwork.tech().openedThickerPolygonNode, ep, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
            if (bbNi == null) {
                return null;
            }
            EPoint[] boxOutline = new EPoint[5];
            if (ep.getIconGenExportPlacement() == 1 && ep.isIconGenExportPlacementExact()) {
                boxOutline[0] = EPoint.fromLambda(cellBounds.getMinX(), cellBounds.getMinY());
                boxOutline[1] = EPoint.fromLambda(cellBounds.getMinX(), cellBounds.getMaxY());
                boxOutline[2] = EPoint.fromLambda(cellBounds.getMaxX(), cellBounds.getMaxY());
                boxOutline[3] = EPoint.fromLambda(cellBounds.getMaxX(), cellBounds.getMinY());
                boxOutline[4] = EPoint.fromLambda(cellBounds.getMinX(), cellBounds.getMinY());
            } else {
                boxOutline[0] = EPoint.fromLambda(-xSize / 2.0, -ySize / 2.0);
                boxOutline[1] = EPoint.fromLambda(-xSize / 2.0, ySize / 2.0);
                boxOutline[2] = EPoint.fromLambda(xSize / 2.0, ySize / 2.0);
                boxOutline[3] = EPoint.fromLambda(xSize / 2.0, -ySize / 2.0);
                boxOutline[4] = EPoint.fromLambda(-xSize / 2.0, -ySize / 2.0);
            }
            bbNi.setTrace(boxOutline);
            TextDescriptor td = ep.getAnnotationTextDescriptor().withRelSize(ep.getIconGenBodyTextSize());
            bbNi.newVar(Schematics.SCHEM_FUNCTION, (Object)curCell.getName(), td);
        }
        int total = 0;
        for (ShadowExport se6 : shadowExportList) {
            int portPosition = (Integer)portIndex.get(se6);
            int index = (Integer)portSide.get(se6);
            double spacing = ep.getIconGenLeadSpacing();
            double xPos = 0.0;
            double yPos = 0.0;
            double xBBPos = 0.0;
            double yBBPos = 0.0;
            if (ep.getIconGenExportPlacement() == 1 && ep.isIconGenExportPlacementExact()) {
                xBBPos = xPos = se6.center.getX();
                yBBPos = yPos = se6.center.getY();
            } else {
                switch (index) {
                    case 0: {
                        xBBPos = -xSize / 2.0;
                        xPos = xBBPos - ep.getIconGenLeadLength();
                        if (leftSide * 2 < rightSide) {
                            spacing = ep.getIconGenLeadSpacing() * 2.0;
                        }
                        yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(leftSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        break;
                    }
                    case 1: {
                        xBBPos = xSize / 2.0;
                        xPos = xBBPos + ep.getIconGenLeadLength();
                        if (rightSide * 2 < leftSide) {
                            spacing = ep.getIconGenLeadSpacing() * 2.0;
                        }
                        yBBPos = yPos = ySize / 2.0 - ((ySize - (double)(rightSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        break;
                    }
                    case 2: {
                        if (topSide * 2 < bottomSide) {
                            spacing = ep.getIconGenLeadSpacing() * 2.0;
                        }
                        xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(topSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        yBBPos = ySize / 2.0;
                        yPos = yBBPos + ep.getIconGenLeadLength();
                        break;
                    }
                    case 3: {
                        if (bottomSide * 2 < topSide) {
                            spacing = ep.getIconGenLeadSpacing() * 2.0;
                        }
                        xBBPos = xPos = xSize / 2.0 - ((xSize - (double)(bottomSide - 1) * spacing) / 2.0 + (double)portPosition * spacing);
                        yBBPos = -ySize / 2.0;
                        yPos = yBBPos - ep.getIconGenLeadLength();
                    }
                }
            }
            int rotation = (Integer)portRotation.get(se6);
            if (!IconParameters.makeIconExportBase(se6.exportName, se6.isBus, se6.originals.get(0), ep, index, xPos, yPos, xBBPos, yBBPos, iconCell, rotation)) continue;
            ++total;
        }
        if (!ep.isIconGenDrawBody() && !ep.isIconGenDrawLeads() && ep.isPlaceCellCenter() && total <= 1) {
            NodeInst.newInstance(Generic.tech().invisiblePinNode, ep, new Point2D.Double(0.0, 0.0), xSize, ySize, iconCell);
        }
        return iconCell;
    }

    private int iconPosition(Export pp) {
        PortCharacteristic character = pp.getCharacteristic();
        if (pp.isPower()) {
            character = PortCharacteristic.PWR;
        }
        if (pp.isGround()) {
            character = PortCharacteristic.GND;
        }
        if (character == PortCharacteristic.IN) {
            return this.inputSide;
        }
        if (character == PortCharacteristic.OUT) {
            return this.outputSide;
        }
        if (character == PortCharacteristic.BIDIR) {
            return this.bidirSide;
        }
        if (character == PortCharacteristic.PWR) {
            return this.pwrSide;
        }
        if (character == PortCharacteristic.GND) {
            return this.gndSide;
        }
        if (character.isClock()) {
            return this.clkSide;
        }
        return this.inputSide;
    }

    public static boolean makeIconExport(Export pp, EditingPreferences ep, int index, double xPos, double yPos, double xBBPos, double yBBPos, Cell np, int textRotation) {
        boolean isBus = pp.getBasePort().connectsTo(Schematics.tech().bus_arc) && pp.getNameKey().isBus();
        return IconParameters.makeIconExportBase(pp.getName(), isBus, pp, ep, index, xPos, yPos, xBBPos, yBBPos, np, textRotation);
    }

    public static boolean makeIconExportBase(String name, boolean isBus, Export sample, EditingPreferences ep, int index, double xPos, double yPos, double xBBPos, double yBBPos, Cell np, int textRotation) {
        NodeInst pinNi;
        PrimitiveNode pinType = Generic.tech().universalPinNode;
        double pinSizeX = 0.0;
        double pinSizeY = 0.0;
        if (ep.getIconGenExportTech() != 0) {
            pinType = Schematics.tech().busPinNode;
            pinSizeX = pinType.getDefWidth(ep);
            pinSizeY = pinType.getDefHeight(ep);
        }
        ArcProto wireType = Schematics.tech().wire_arc;
        if (isBus) {
            wireType = Schematics.tech().bus_arc;
            pinType = Schematics.tech().busPinNode;
            pinSizeX = pinType.getDefWidth(ep);
            pinSizeY = pinType.getDefHeight(ep);
        }
        if (!ep.isIconGenDrawLeads()) {
            xPos = xBBPos;
            yPos = yBBPos;
        }
        if ((pinNi = NodeInst.newInstance(pinType, ep, new Point2D.Double(xPos, yPos), pinSizeX, pinSizeY, np)) == null) {
            return false;
        }
        PortInst pi = pinNi.getOnlyPortInst();
        Export port = Export.newInstance(np, pi, name, ep, sample.getCharacteristic());
        if (port != null) {
            TextDescriptor td = port.getTextDescriptor(Export.EXPORT_NAME);
            if (textRotation != 0) {
                td = td.withRotation(AbstractTextDescriptor.Rotation.getRotationAt(textRotation));
            }
            block0 : switch (ep.getIconGenExportStyle()) {
                case 0: {
                    td = td.withPos(AbstractTextDescriptor.Position.CENT);
                    break;
                }
                case 1: {
                    block5 : switch (index) {
                        case 0: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                    break;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                    break;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                    break;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                    break;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                    break;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                    break;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                    break;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                    break;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                    break;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                    break block5;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                    break block5;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                    break block5;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                    break block0;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                    break block0;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                    break block0;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                }
                            }
                            break block0;
                        }
                        case 1: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                    break block0;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                    break block0;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                    break block0;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                    break block0;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                    break block0;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                    break block0;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                }
                            }
                            break block0;
                        }
                        case 3: {
                            switch (textRotation) {
                                case 0: {
                                    td = td.withPos(AbstractTextDescriptor.Position.DOWN);
                                    break block0;
                                }
                                case 1: {
                                    td = td.withPos(AbstractTextDescriptor.Position.LEFT);
                                    break block0;
                                }
                                case 2: {
                                    td = td.withPos(AbstractTextDescriptor.Position.UP);
                                    break block0;
                                }
                                case 3: {
                                    td = td.withPos(AbstractTextDescriptor.Position.RIGHT);
                                }
                            }
                        }
                    }
                }
            }
            port.setTextDescriptor(Export.EXPORT_NAME, td);
            double xOffset = 0.0;
            double yOffset = 0.0;
            int loc = ep.getIconGenExportLocation();
            if (!ep.isIconGenDrawLeads()) {
                loc = 0;
            }
            switch (loc) {
                case 0: {
                    xOffset = xBBPos - xPos;
                    yOffset = yBBPos - yPos;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    xOffset = (xPos + xBBPos) / 2.0 - xPos;
                    yOffset = (yPos + yBBPos) / 2.0 - yPos;
                }
            }
            port.setOff(Export.EXPORT_NAME, xOffset, yOffset);
            port.setAlwaysDrawn(ep.isIconsAlwaysDrawn());
            port.copyVarsFrom(sample);
        }
        if (ep.isIconGenDrawLeads()) {
            PortInst tail;
            PortInst head2;
            ArcInst ai;
            double hei;
            double wid;
            NodeInst ni;
            pinType = wireType.findPinProto();
            if (pinType == Schematics.tech().busPinNode) {
                pinType = Generic.tech().invisiblePinNode;
            }
            if ((ni = NodeInst.newInstance(pinType, ep, new Point2D.Double(xBBPos, yBBPos), wid = pinType.getDefWidth(ep), hei = pinType.getDefHeight(ep), np)) != null && (ai = ArcInst.makeInstance(wireType, ep, head2 = ni.getOnlyPortInst(), tail = pinNi.getOnlyPortInst(), new Point2D.Double(xBBPos, yBBPos), new Point2D.Double(xPos, yPos), null)) != null && wireType == Schematics.tech().bus_arc) {
                ai.setHeadExtended(false);
                ai.setTailExtended(false);
            }
        }
        return true;
    }

    private static class ShadowExportByName
    implements Comparator<ShadowExport> {
        private ShadowExportByName() {
        }

        @Override
        public int compare(ShadowExport p1, ShadowExport p2) {
            String p1Name = p1.exportName;
            String p2Name = p2.exportName;
            return p1Name.compareTo(p2Name);
        }
    }

    private static class ShadowExport
    implements Comparable<ShadowExport> {
        String exportName;
        List<Integer> indices;
        List<Export> originals;
        Point2D center;
        boolean isBus;
        boolean nearLeft;
        boolean nearRight;
        boolean nearTop;
        boolean nearBottom;

        ShadowExport(String name) {
            this.exportName = name;
            this.indices = new ArrayList<Integer>();
            this.originals = new ArrayList<Export>();
            this.isBus = false;
            this.nearBottom = false;
            this.nearTop = false;
            this.nearRight = false;
            this.nearLeft = false;
        }

        @Override
        public int compareTo(ShadowExport other) {
            double angle2;
            Cell cell = this.originals.get(0).getParent();
            ERectangle bounds = cell.getBounds();
            Point2D.Double cellCtr = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            double angle1 = DBMath.figureAngleRadians(cellCtr, this.center);
            if (angle1 < (angle2 = DBMath.figureAngleRadians(cellCtr, other.center))) {
                return 1;
            }
            if (angle1 > angle2) {
                return -1;
            }
            return 0;
        }
    }
}

