/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory.image;

import java.awt.Image;
import java.awt.Toolkit;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.factory.AbstractFactoryModule;

public class GIFImageFactoryModule
extends AbstractFactoryModule {
    private static final int[] FINGERPRINT = new int[]{71, 73, 70, 56};
    private static final String[] MIMETYPES = new String[]{"image/gif", "image/x-xbitmap", "image/gi_"};
    private static final String[] FILEEXTENSIONS = new String[]{".gif"};

    public int getHeaderFingerprintSize() {
        return FINGERPRINT.length;
    }

    protected int[] getFingerPrint() {
        return FINGERPRINT;
    }

    protected String[] getMimeTypes() {
        return MIMETYPES;
    }

    protected String[] getFileExtensions() {
        return FILEEXTENSIONS;
    }

    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceLoadingException {
        long version = data.getVersion(caller);
        Image image = Toolkit.getDefaultToolkit().createImage(data.getResource(caller));
        return new SimpleResource(data.getKey(), image, Image.class, version);
    }
}

