/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.apache.activeio.xnet.ServerService;
import org.apache.activeio.xnet.ServiceDaemon;
import org.apache.activeio.xnet.ServiceException;
import org.apache.activeio.xnet.ServiceLogger;
import org.apache.activeio.xnet.ServicePool;
import org.apache.activeio.xnet.hba.IPAddressPermission;
import org.apache.activeio.xnet.hba.ServiceAccessController;

public class StandardServiceStack {
    private String name;
    private ServiceDaemon daemon;
    private ServiceLogger logger;
    private ServiceAccessController hba;
    private ServicePool pool;
    private ServerService server;
    private String host;

    public StandardServiceStack(String name, int port, String host, IPAddressPermission[] allowHosts, String[] logOnSuccess, String[] logOnFailure, Executor executor, ServerService server) throws UnknownHostException {
        this.server = server;
        this.name = name;
        this.host = host;
        InetAddress address = InetAddress.getByName(host);
        this.pool = new ServicePool(server, executor);
        this.hba = new ServiceAccessController(name, this.pool, allowHosts);
        this.logger = new ServiceLogger(name, this.hba, logOnSuccess, logOnFailure);
        this.daemon = new ServiceDaemon(name, this.logger, address, port);
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.daemon.getAddress();
    }

    public InetSocketAddress getFullAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.daemon.getPort();
    }

    public int getSoTimeout() throws IOException {
        return this.daemon.getSoTimeout();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.daemon.setSoTimeout(timeout);
    }

    public String[] getLogOnSuccess() {
        return this.logger.getLogOnSuccess();
    }

    public String[] getLogOnFailure() {
        return this.logger.getLogOnFailure();
    }

    public IPAddressPermission[] getAllowHosts() {
        return this.hba.getAllowHosts();
    }

    public void setAllowHosts(IPAddressPermission[] allowHosts) {
        this.hba.setAllowHosts(allowHosts);
    }

    public void doStart() throws Exception {
        this.daemon.start();
    }

    public void doStop() throws Exception {
        this.daemon.stop();
    }

    public void doFail() {
        try {
            this.daemon.stop();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }
}

