/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.support.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInflightRepository.class);
    private final ConcurrentMap<String, Exchange> inflight = new ConcurrentHashMap<String, Exchange>();
    private final ConcurrentMap<String, AtomicInteger> routeCount = new ConcurrentHashMap<String, AtomicInteger>();

    @Override
    public void add(Exchange exchange) {
        this.inflight.put(exchange.getExchangeId(), exchange);
    }

    @Override
    public void remove(Exchange exchange) {
        this.inflight.remove(exchange.getExchangeId());
    }

    @Override
    public void add(Exchange exchange, String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        if (existing != null) {
            existing.incrementAndGet();
        }
    }

    @Override
    public void remove(Exchange exchange, String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        if (existing != null) {
            existing.decrementAndGet();
        }
    }

    @Override
    public int size() {
        return this.inflight.size();
    }

    @Override
    @Deprecated
    public int size(Endpoint endpoint) {
        return 0;
    }

    @Override
    public void addRoute(String routeId) {
        this.routeCount.putIfAbsent(routeId, new AtomicInteger(0));
    }

    @Override
    public void removeRoute(String routeId) {
        this.routeCount.remove(routeId);
    }

    @Override
    public int size(String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        return existing != null ? existing.get() : 0;
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse() {
        return this.browse(null, -1, false);
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse(String fromRouteId) {
        return this.browse(fromRouteId, -1, false);
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse(int limit, boolean sortByLongestDuration) {
        return this.browse(null, limit, sortByLongestDuration);
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse(String fromRouteId, int limit, boolean sortByLongestDuration) {
        Stream<Object> values = fromRouteId == null ? this.inflight.values().stream() : this.inflight.values().stream().filter(e -> fromRouteId.equals(e.getFromRouteId()));
        values = sortByLongestDuration ? values.sorted((e1, e2) -> {
            long d1 = DefaultInflightRepository.getExchangeDuration(e1);
            long d2 = DefaultInflightRepository.getExchangeDuration(e2);
            return -1 * Long.compare(d1, d2);
        }) : values.sorted(Comparator.comparing(Exchange::getExchangeId));
        if (limit > 0) {
            values = values.limit(limit);
        }
        List answer = values.map(x$0 -> new InflightExchangeEntry((Exchange)x$0)).collect(Collectors.toList());
        return Collections.unmodifiableCollection(answer);
    }

    @Override
    public InflightRepository.InflightExchange oldest(String fromRouteId) {
        Stream<Object> values = fromRouteId == null ? this.inflight.values().stream() : this.inflight.values().stream().filter(e -> fromRouteId.equals(e.getFromRouteId()));
        Exchange first = values.sorted((e1, e2) -> {
            long d1 = DefaultInflightRepository.getExchangeDuration(e1);
            long d2 = DefaultInflightRepository.getExchangeDuration(e2);
            return -1 * Long.compare(d1, d2);
        }).findFirst().orElse(null);
        if (first != null) {
            return new InflightExchangeEntry(first);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still {} inflight exchanges.", (Object)count);
        } else {
            LOG.debug("Shutting down with no inflight exchanges.");
        }
        this.routeCount.clear();
    }

    private static long getExchangeDuration(Exchange exchange) {
        long duration = 0L;
        Date created = exchange.getCreated();
        if (created != null) {
            duration = System.currentTimeMillis() - created.getTime();
        }
        return duration;
    }

    private static final class InflightExchangeEntry
    implements InflightRepository.InflightExchange {
        private final Exchange exchange;

        private InflightExchangeEntry(Exchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public long getDuration() {
            return DefaultInflightRepository.getExchangeDuration(this.exchange);
        }

        @Override
        public long getElapsed() {
            LinkedList list = this.exchange.getProperty("CamelMessageHistory", LinkedList.class);
            if (list == null || list.isEmpty()) {
                return 0L;
            }
            MessageHistory history = (MessageHistory)list.getLast();
            if (history != null) {
                long elapsed = history.getElapsed();
                if (elapsed == 0L && history.getTime() > 0L) {
                    elapsed = System.currentTimeMillis() - history.getTime();
                }
                return elapsed;
            }
            return 0L;
        }

        @Override
        public String getNodeId() {
            LinkedList list = this.exchange.getProperty("CamelMessageHistory", LinkedList.class);
            if (list == null || list.isEmpty()) {
                return null;
            }
            MessageHistory history = (MessageHistory)list.getLast();
            if (history != null) {
                return history.getNode().getId();
            }
            return null;
        }

        @Override
        public String getFromRouteId() {
            return this.exchange.getFromRouteId();
        }

        @Override
        public String getRouteId() {
            return this.getAtRouteId();
        }

        @Override
        public String getAtRouteId() {
            LinkedList list = this.exchange.getProperty("CamelMessageHistory", LinkedList.class);
            if (list == null || list.isEmpty()) {
                return null;
            }
            MessageHistory history = (MessageHistory)list.getLast();
            if (history != null) {
                return history.getRouteId();
            }
            return null;
        }

        public String toString() {
            return "InflightExchangeEntry[exchangeId=" + this.exchange.getExchangeId() + "]";
        }
    }
}

