/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.util.StringHelper;

public class DataType {
    public static final String JAVA_TYPE_PREFIX = "java";
    private String model;
    private String name;
    private boolean isJavaType;
    private String typeString;

    public DataType(String urn) {
        if (urn != null) {
            String[] split = StringHelper.splitOnCharacter(urn, ":", 2);
            this.model = split[0];
            this.isJavaType = this.model.equals(JAVA_TYPE_PREFIX);
            if (split.length > 1) {
                this.name = split[1];
            }
        }
    }

    public DataType(Class<?> clazz) {
        this.model = JAVA_TYPE_PREFIX;
        this.isJavaType = true;
        this.name = clazz.getName();
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public boolean isJavaType() {
        return this.isJavaType;
    }

    public String toString() {
        if (this.typeString == null) {
            this.typeString = this.name != null && !this.name.isEmpty() ? this.model + ":" + this.name : this.model;
        }
        return this.typeString;
    }

    public boolean equals(Object target) {
        if (target instanceof DataType) {
            DataType targetdt = (DataType)target;
            String targetModel = targetdt.getModel();
            String targetName = targetdt.getName();
            if (targetModel == null) {
                return false;
            }
            if (targetName == null) {
                return targetModel.equals(this.getModel()) && this.getName() == null;
            }
            return targetModel.equals(this.getModel()) && targetName.equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

