/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.IPv6LocalConnectionTests;
import org.apache.commons.vfs2.ProviderTestConfig;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileProvider;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav4.test.JackrabbitMain;
import org.apache.commons.vfs2.provider.webdav4.test.JcrUtils;
import org.apache.commons.vfs2.provider.webdav4.test.Webdav4ProviderTestSuite;
import org.apache.commons.vfs2.util.FreeSocketPortUtil;
import org.apache.jackrabbit.core.TransientRepository;
import org.junit.Test;

public class Webdav4ProviderTestCase
extends AbstractProviderTestConfig {
    private static final String USER_ID = "admin";
    private static final String PASSWORD = "admin";
    private static final char[] PASSWORD_CHARS = "admin".toCharArray();
    private static int SocketPort;
    private static final String TEST_URI = "test.webdav4.uri";
    private static JackrabbitMain jrMain;
    private static String ConnectionUri;
    private static Path RepoDirectory;
    private static final boolean DEBUG;

    static Path createTempDirectory() throws IOException {
        Path base = Paths.get("target/test", new String[0]).normalize();
        Files.createDirectories(base, new FileAttribute[0]);
        Path tempFile = Files.createTempFile(base, "WebdavProviderTestCase_", ".tmp", new FileAttribute[0]);
        Files.delete(tempFile);
        Files.createDirectories(base, new FileAttribute[0]);
        if (DEBUG) {
            System.out.println("Working in " + tempFile);
        }
        return tempFile;
    }

    private static void dump(Node node) throws RepositoryException {
        Webdav4ProviderTestCase.message(node.getPath());
        if (node.getName().equals("jcr:system") || node.getName().equals("jcr:content")) {
            return;
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isMultiple()) {
                Value[] values;
                for (Value value : values = property.getValues()) {
                    Webdav4ProviderTestCase.message(property.getPath() + " = " + value.getString());
                }
                continue;
            }
            Webdav4ProviderTestCase.message(property.getPath() + " = " + property.getString());
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Webdav4ProviderTestCase.dump(nodes.nextNode());
        }
    }

    private static void dump(Path repoDirectory) throws Exception {
        TransientRepository repository = Webdav4ProviderTestCase.getTransientRepository(repoDirectory);
        try {
            Session session = Webdav4ProviderTestCase.getSession(repository);
            Webdav4ProviderTestCase.message("Root node dump:");
            Webdav4ProviderTestCase.dump(session.getRootNode());
            session.logout();
        }
        finally {
            repository.shutdown();
        }
    }

    private static Session getSession(TransientRepository repository) throws RepositoryException {
        return repository.login((Credentials)new SimpleCredentials("admin", PASSWORD_CHARS));
    }

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static TransientRepository getTransientRepository(Path repoDirectory) {
        return new TransientRepository(repoDirectory.resolve("repository.xml").toString(), repoDirectory.toString());
    }

    private static void importFiles(Node parent, File sourceDir) throws RepositoryException, IOException {
        File[] files;
        for (File file : files = sourceDir.listFiles()) {
            if (file.isFile()) {
                try (InputStream data = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    Webdav4ProviderTestCase.message("Importing file " + file);
                    JcrUtils.putFile(parent, file.getName(), "application/octet-stream", data);
                    continue;
                }
            }
            if (!file.isDirectory()) continue;
            Webdav4ProviderTestCase.message("Importing folder " + file);
            Node folder = JcrUtils.getOrAddFolder(parent, file.getName());
            Webdav4ProviderTestCase.importFiles(folder, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFiles(Path repoDirectory, File sourceDir) throws Exception {
        TransientRepository repository = Webdav4ProviderTestCase.getTransientRepository(repoDirectory);
        try {
            Session session = Webdav4ProviderTestCase.getSession(repository);
            Webdav4ProviderTestCase.importFiles(session.getRootNode(), sourceDir);
            session.save();
            session.logout();
        }
        finally {
            repository.shutdown();
        }
    }

    private static void message(IOException e) {
        if (DEBUG) {
            e.printStackTrace();
        }
    }

    private static void message(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    private static void setUpClass() throws Exception {
        RepoDirectory = Webdav4ProviderTestCase.createTempDirectory();
        Webdav4ProviderTestCase.message("Created temp directory " + RepoDirectory);
        Webdav4ProviderTestCase.importFiles(RepoDirectory, new File(VfsTestUtils.getTestDirectory()));
        Webdav4ProviderTestCase.dump(RepoDirectory);
        Webdav4ProviderTestCase.startJackrabbit(RepoDirectory);
        Webdav4ProviderTestCase.message("Returned from " + JackrabbitMain.class.getName() + " " + SocketPort);
    }

    private static void startJackrabbit(Path repoDirectory) throws Exception {
        boolean quiet = false;
        if (!DEBUG) {
            quiet = true;
        }
        jrMain = new JackrabbitMain(new String[]{"--port", Integer.toString(SocketPort), "--repo", repoDirectory.toString(), quiet ? "--quiet" : ""}){};
        jrMain.run();
    }

    public static junit.framework.Test suite() throws Exception {
        return new Webdav4ProviderTestSuite((ProviderTestConfig)new Webdav4ProviderTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(Webdav4ProviderTestCase.class);
                if (Webdav4ProviderTestCase.getSystemTestUriOverride() == null) {
                    this.addTests(IPv6LocalConnectionTests.class);
                }
            }

            protected void setUp() throws Exception {
                if (Webdav4ProviderTestCase.getSystemTestUriOverride() == null) {
                    Webdav4ProviderTestCase.setUpClass();
                }
                try {
                    DefaultFileSystemManager manager = (DefaultFileSystemManager)VFS.getManager();
                    if (!manager.hasProvider("webdav4")) {
                        manager.addProvider("webdav4", (FileProvider)new Webdav4FileProvider());
                    }
                    super.setUp();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            protected void tearDown() throws Exception {
                Webdav4ProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() {
        jrMain.shutdown();
        if (DEBUG) {
            Webdav4ProviderTestCase.message("Skipping cleanup of " + RepoDirectory);
            return;
        }
        try {
            Webdav4ProviderTestCase.message("Deleting temp directory " + RepoDirectory);
            PathUtils.deleteDirectory((Path)RepoDirectory);
        }
        catch (IOException e) {
            Webdav4ProviderTestCase.message(e);
            try {
                Files.delete(RepoDirectory);
            }
            catch (IOException e1) {
                Webdav4ProviderTestCase.message("Directory will be deleted on VM exit " + RepoDirectory);
                RepoDirectory.toFile().deleteOnExit();
            }
        }
    }

    public Webdav4ProviderTestCase() throws IOException {
        SocketPort = FreeSocketPortUtil.findFreeLocalPort();
        Webdav4ProviderTestCase.message("FreeSocketPortUtil.findFreeLocalPort() = " + SocketPort);
        ConnectionUri = String.format("webdav4://%s:%s@localhost:%d/repository/default", "admin", "admin", SocketPort);
    }

    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = Webdav4ProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        Webdav4FileSystemConfigBuilder builder = (Webdav4FileSystemConfigBuilder)manager.getFileSystemConfigBuilder("webdav4");
        FileSystemOptions opts = new FileSystemOptions();
        builder.setRootURI(opts, uri);
        return manager.resolveFile(uri, opts);
    }

    public boolean isFileSystemRootAccessible() {
        return false;
    }

    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("webdav4", (FileProvider)new Webdav4FileProvider());
        manager.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
    }

    @Test
    public void testResolveIPv6Url() throws Exception {
        String ipv6Url = "webdav4://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt";
        FileObject fileObject = VFS.getManager().resolveFile("webdav4://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt", new FileSystemOptions());
        Webdav4ProviderTestCase.assertEquals((String)"webdav4://user:pass@[fe80::1c42:dae:8370:aea6%en1]/", (String)fileObject.getFileSystem().getRootURI());
        Webdav4ProviderTestCase.assertEquals((String)"webdav4://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt", (String)fileObject.getName().getURI());
    }

    static {
        DEBUG = Boolean.getBoolean("Webdav4ProviderTestCase.Debug");
    }
}

