/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.util.Strings;

public final class SchemaObjectSorter {
    private SchemaObjectSorter() {
    }

    public static Iterable<AttributeType> hierarchicalOrdered(List<AttributeType> attributeTypes) {
        return new SchemaObjectIterable<AttributeType>(attributeTypes, new ReferenceCallback<AttributeType>(){

            @Override
            public Collection<String> getSuperiorOids(AttributeType at) {
                return Collections.singleton(at.getSuperiorOid());
            }
        });
    }

    public static Iterable<ObjectClass> sortObjectClasses(List<ObjectClass> objectClasses) {
        return new SchemaObjectIterable<ObjectClass>(objectClasses, new ReferenceCallback<ObjectClass>(){

            @Override
            public Collection<String> getSuperiorOids(ObjectClass oc) {
                return oc.getSuperiorOids();
            }
        });
    }

    private static final class SchemaObjectIterator<T extends SchemaObject>
    implements Iterator<T> {
        private final List<T> schemaObjects;
        private final ReferenceCallback<T> callback;
        private final Map<String, String> oid2numericOid;
        private final Map<String, T> numericOid2schemaObject;
        private int loopCount;
        private Iterator<Map.Entry<String, T>> schemaObjectIterator;

        private SchemaObjectIterator(List<T> schemaObjects, ReferenceCallback<T> callback) {
            this.schemaObjects = schemaObjects;
            this.callback = callback;
            this.oid2numericOid = new HashMap<String, String>();
            this.numericOid2schemaObject = new TreeMap<String, T>();
            this.loopCount = 0;
            for (SchemaObject schemaObject : schemaObjects) {
                String oid = Strings.toLowerCaseAscii((String)schemaObject.getOid());
                this.oid2numericOid.put(oid, oid);
                for (String name : schemaObject.getNames()) {
                    this.oid2numericOid.put(Strings.toLowerCaseAscii((String)name), oid);
                }
                this.numericOid2schemaObject.put(oid, schemaObject);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.numericOid2schemaObject.isEmpty();
        }

        @Override
        public T next() {
            while (!this.maxLoopCountReached()) {
                Iterator<Map.Entry<String, T>> iterator = this.getIterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, T> entry = iterator.next();
                    SchemaObject schemaObject = (SchemaObject)entry.getValue();
                    Collection<String> superiorOids = this.callback.getSuperiorOids(schemaObject);
                    if (superiorOids == null) {
                        iterator.remove();
                        return (T)schemaObject;
                    }
                    boolean allSuperiorsProcessed = true;
                    for (String superiorOid : superiorOids) {
                        SchemaObject superiorSchemaObject;
                        String superiorNumeridOid;
                        if (superiorOid == null || (superiorNumeridOid = this.oid2numericOid.get(Strings.toLowerCaseAscii((String)superiorOid))) == null || (superiorSchemaObject = (SchemaObject)this.numericOid2schemaObject.get(Strings.toLowerCaseAscii((String)superiorNumeridOid))) == null) continue;
                        allSuperiorsProcessed = false;
                        break;
                    }
                    if (!allSuperiorsProcessed) continue;
                    iterator.remove();
                    return (T)schemaObject;
                }
            }
            throw new IllegalStateException("Loop detected: " + this.numericOid2schemaObject.values());
        }

        private Iterator<Map.Entry<String, T>> getIterator() {
            if (this.schemaObjectIterator != null && this.schemaObjectIterator.hasNext()) {
                return this.schemaObjectIterator;
            }
            if (!this.maxLoopCountReached()) {
                this.schemaObjectIterator = this.numericOid2schemaObject.entrySet().iterator();
                ++this.loopCount;
                return this.schemaObjectIterator;
            }
            throw new IllegalStateException("Loop detected: " + this.numericOid2schemaObject.values());
        }

        private boolean maxLoopCountReached() {
            return this.loopCount > this.schemaObjects.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SchemaObjectIterable<T extends SchemaObject>
    implements Iterable<T> {
        private final List<T> schemaObjects;
        private final ReferenceCallback<T> callback;

        private SchemaObjectIterable(List<T> schemaObjects, ReferenceCallback<T> callback) {
            this.schemaObjects = schemaObjects;
            this.callback = callback;
        }

        @Override
        public Iterator<T> iterator() {
            return new SchemaObjectIterator(this.schemaObjects, this.callback);
        }
    }

    private static interface ReferenceCallback<T extends SchemaObject> {
        public Collection<String> getSuperiorOids(T var1);
    }
}

