/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Strings;

public final class BitStringSyntaxChecker
extends SyntaxChecker {
    public static final BitStringSyntaxChecker INSTANCE = new BitStringSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.6");

    private BitStringSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean isValid(String strValue) {
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
            return false;
        }
        int pos = 0;
        if (!Strings.isCharASCII((String)strValue, (int)pos++, (char)'\'')) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
            return false;
        }
        if (!Chars.isBit((String)strValue, (int)pos++)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
            return false;
        }
        while (Chars.isBit((String)strValue, (int)pos)) {
            ++pos;
        }
        if (!Strings.isCharASCII((String)strValue, (int)pos++, (char)'\'')) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
            return false;
        }
        if (!Strings.isCharASCII((String)strValue, (int)pos, (char)'B')) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{strValue}));
        }
        return true;
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        return BitStringSyntaxChecker.isValid(strValue);
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<BitStringSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.6");
        }

        @Override
        public BitStringSyntaxChecker build() {
            return new BitStringSyntaxChecker(this.oid);
        }
    }
}

