/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueContainer;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncDoneValueGrammar
extends AbstractGrammar<SyncDoneValueContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncDoneValueGrammar.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final SyncDoneValueGrammar INSTANCE = new SyncDoneValueGrammar();

    private SyncDoneValueGrammar() {
        this.setName(SyncDoneValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncDoneValueStatesEnum.LAST_SYNC_DONE_VALUE_STATE.ordinal()][256];
        this.transitions[SyncDoneValueStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SyncDoneValueStatesEnum.START_STATE, (Enum)SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<SyncDoneValueContainer>("Initialization"){

            public void action(SyncDoneValueContainer container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE, (Enum)SyncDoneValueStatesEnum.COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncDoneValueContainer>("Set SyncDoneValueControl cookie"){

            public void action(SyncDoneValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = {}", (Object)Strings.dumpBytes((byte[])cookie));
                }
                container.getSyncDoneValueControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
        GrammarAction<SyncDoneValueContainer> refreshDeletesTagAction = new GrammarAction<SyncDoneValueContainer>("set SyncDoneValueControl refreshDeletes flag"){

            public void action(SyncDoneValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse((BerValue)value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDeletes = {}", (Object)refreshDeletes);
                    }
                    container.getSyncDoneValueControl().setRefreshDeletes(refreshDeletes);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_04024, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
            }
        };
        this.transitions[SyncDoneValueStatesEnum.COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncDoneValueStatesEnum.COOKIE_STATE, (Enum)SyncDoneValueStatesEnum.REFRESH_DELETES_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)refreshDeletesTagAction);
        this.transitions[SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE, (Enum)SyncDoneValueStatesEnum.REFRESH_DELETES_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)refreshDeletesTagAction);
    }

    public static Grammar<SyncDoneValueContainer> getInstance() {
        return INSTANCE;
    }
}

