/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci.protectedItem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.model.entry.Attribute;

public class AttributeValueItem
extends ProtectedItem {
    private final Set<Attribute> attributes;

    public AttributeValueItem(Set<Attribute> attributes) {
        this.attributes = Collections.unmodifiableSet(attributes);
    }

    public Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    public int hashCode() {
        int hash = 37;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                hash = hash * 17 + attribute.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AttributeValueItem) {
            AttributeValueItem that = (AttributeValueItem)o;
            if (this.attributes != null) {
                if (that.attributes == null || that.attributes.size() != this.attributes.size()) {
                    return false;
                }
                for (Attribute attribute : this.attributes) {
                    if (that.attributes.contains(attribute)) continue;
                    return false;
                }
                return true;
            }
            return this.attributes == null;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("attributeValue {");
        boolean isFirst = true;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(attribute.getId());
                buf.append('=');
                buf.append(attribute.get());
            }
        }
        buf.append(" }");
        return buf.toString();
    }
}

