/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestAttributeDesc
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestAttributeDesc.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchRequestAttributeDesc() {
        super("Store attribute description");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        String attributeDescription = null;
        if (tlv.getLength() != 0 && !Strings.isEmpty((String)(attributeDescription = Strings.utf8ToString((byte[])tlv.getValue().getData())).trim())) {
            ((SearchRequest)searchRequestDecorator.getDecorated()).addAttributes(new String[]{attributeDescription});
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Decoded Attribute Description : {}", (Object)attributeDescription);
        }
    }
}

