/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber.tlv;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.asn1.util.Asn1StringUtils;
import org.apache.directory.api.asn1.util.BitString;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;

public class BerValue {
    private byte[] data;
    private int currentPos;
    public static final byte TRUE_VALUE = -1;
    public static final byte FALSE_VALUE = 0;
    private static final byte[] ENCODED_TRUE = new byte[]{1, 1, -1};
    private static final byte[] ENCODED_FALSE = new byte[]{1, 1, 0};
    private static final int ONE_BYTE_MAX = 127;
    private static final int ONE_BYTE_MIN = -128;
    private static final int TWO_BYTE_MAX = Short.MAX_VALUE;
    private static final int TWO_BYTE_MIN = Short.MIN_VALUE;
    private static final int THREE_BYTE_MAX = 0x7FFFFF;
    private static final int THREE_BYTE_MIN = -8388608;
    private static final long FOUR_BYTE_MAX = Integer.MAX_VALUE;
    private static final long FOUR_BYTE_MIN = Integer.MIN_VALUE;
    private static final long FIVE_BYTE_MAX = 0x7FFFFFFFFFL;
    private static final long FIVE_BYTE_MIN = -549755813888L;
    private static final long SIX_BYTE_MAX = 0x7FFFFFFFFFFFL;
    private static final long SIX_BYTE_MIN = -140737488355328L;
    private static final long SEVEN_BYTE_MAX = 0x7FFFFFFFFFFFFFL;
    private static final long SEVEN_BYTE_MIN = -36028797018963968L;

    public BerValue(byte[] value) {
        this.data = new byte[value.length];
        System.arraycopy(value, 0, this.data, 0, value.length);
        this.currentPos = 0;
    }

    public BerValue() {
        this.data = null;
        this.currentPos = 0;
    }

    public void init(int size) {
        this.data = new byte[size];
        this.currentPos = 0;
    }

    public void reset() {
        this.data = null;
        this.currentPos = 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        int length = data.remaining();
        data.get(this.data, 0, length);
        this.currentPos = length;
    }

    public void addData(ByteBuffer buffer) {
        int length = buffer.remaining();
        buffer.get(this.data, this.currentPos, length);
        this.currentPos += length;
    }

    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, data.length);
        this.currentPos = data.length;
    }

    public void addData(byte[] array) {
        System.arraycopy(array, 0, this.data, this.currentPos, array.length);
        this.currentPos = array.length;
    }

    public int getCurrentLength() {
        return this.currentPos;
    }

    public static int getNbBytes(int value) {
        if (value >= -128 && value <= 127) {
            return 1;
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return 2;
        }
        if (value >= -8388608 && value <= 0x7FFFFF) {
            return 3;
        }
        return 4;
    }

    public static int getNbBytes(long value) {
        if (value >= -128L && value <= 127L) {
            return 1;
        }
        if (value >= -32768L && value <= 32767L) {
            return 2;
        }
        if (value >= -8388608L && value <= 0x7FFFFFL) {
            return 3;
        }
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return 4;
        }
        if (value >= -549755813888L && value <= 0x7FFFFFFFFFL) {
            return 5;
        }
        if (value >= -140737488355328L && value <= 0x7FFFFFFFFFFFL) {
            return 6;
        }
        if (value >= -36028797018963968L && value <= 0x7FFFFFFFFFFFFFL) {
            return 7;
        }
        return 8;
    }

    public static byte[] getBytes(int value) {
        byte[] bytes;
        if (value >= 0) {
            if (value >= 0 && value <= 127) {
                bytes = new byte[]{(byte)value};
            } else if (value > 127 && value <= Short.MAX_VALUE) {
                bytes = new byte[2];
                bytes[1] = (byte)value;
                bytes[0] = (byte)(value >> 8);
            } else if (value > Short.MAX_VALUE && value <= 0x7FFFFF) {
                bytes = new byte[3];
                bytes[2] = (byte)value;
                bytes[1] = (byte)(value >> 8);
                bytes[0] = (byte)(value >> 16);
            } else {
                bytes = new byte[4];
                bytes[3] = (byte)value;
                bytes[2] = (byte)(value >> 8);
                bytes[1] = (byte)(value >> 16);
                bytes[0] = (byte)(value >> 24);
            }
        } else if (value == Integer.MIN_VALUE) {
            bytes = new byte[4];
            bytes[3] = (byte)value;
            bytes[2] = (byte)(value >> 8);
            bytes[1] = (byte)(value >> 16);
            bytes[0] = (byte)(value >> 24);
        } else if (value >= -128) {
            bytes = new byte[]{(byte)value};
        } else if (value >= Short.MIN_VALUE) {
            bytes = new byte[2];
            bytes[1] = (byte)value;
            bytes[0] = (byte)(value >> 8);
        } else if (value >= -8388608) {
            bytes = new byte[3];
            bytes[2] = (byte)value;
            bytes[1] = (byte)(value >> 8);
            bytes[0] = (byte)(value >> 16);
        } else {
            bytes = new byte[4];
            bytes[3] = (byte)value;
            bytes[2] = (byte)(value >> 8);
            bytes[1] = (byte)(value >> 16);
            bytes[0] = (byte)(value >> 24);
        }
        return bytes;
    }

    public static byte[] getBytes(long value) {
        byte[] bytes;
        if (value >= 0L) {
            if (value >= 0L && value <= 127L) {
                bytes = new byte[]{(byte)value};
            } else if (value > 127L && value <= 32767L) {
                bytes = new byte[2];
                bytes[1] = (byte)value;
                bytes[0] = (byte)(value >> 8);
            } else if (value > 32767L && value <= 0x7FFFFFL) {
                bytes = new byte[3];
                bytes[2] = (byte)value;
                bytes[1] = (byte)(value >> 8);
                bytes[0] = (byte)(value >> 16);
            } else if (value > 0x7FFFFFL && value <= Integer.MAX_VALUE) {
                bytes = new byte[4];
                bytes[3] = (byte)value;
                bytes[2] = (byte)(value >> 8);
                bytes[1] = (byte)(value >> 16);
                bytes[0] = (byte)(value >> 24);
            } else if (value > Integer.MAX_VALUE && value <= 0x7FFFFFFFFFL) {
                bytes = new byte[5];
                bytes[4] = (byte)value;
                bytes[3] = (byte)(value >> 8);
                bytes[2] = (byte)(value >> 16);
                bytes[1] = (byte)(value >> 24);
                bytes[0] = (byte)(value >> 32);
            } else if (value > 0x7FFFFFFFFFL && value <= 0x7FFFFFFFFFFFL) {
                bytes = new byte[6];
                bytes[5] = (byte)value;
                bytes[4] = (byte)(value >> 8);
                bytes[3] = (byte)(value >> 16);
                bytes[2] = (byte)(value >> 24);
                bytes[1] = (byte)(value >> 32);
                bytes[0] = (byte)(value >> 40);
            } else if (value > 0x7FFFFFFFFFFFL && value <= 0x7FFFFFFFFFFFFFL) {
                bytes = new byte[7];
                bytes[6] = (byte)value;
                bytes[5] = (byte)(value >> 8);
                bytes[4] = (byte)(value >> 16);
                bytes[3] = (byte)(value >> 24);
                bytes[2] = (byte)(value >> 32);
                bytes[1] = (byte)(value >> 40);
                bytes[0] = (byte)(value >> 48);
            } else {
                bytes = new byte[8];
                bytes[7] = (byte)value;
                bytes[6] = (byte)(value >> 8);
                bytes[5] = (byte)(value >> 16);
                bytes[4] = (byte)(value >> 24);
                bytes[3] = (byte)(value >> 32);
                bytes[2] = (byte)(value >> 40);
                bytes[1] = (byte)(value >> 48);
                bytes[0] = (byte)(value >> 56);
            }
        } else if (value == Long.MIN_VALUE) {
            bytes = new byte[8];
            bytes[7] = 0;
            bytes[6] = 0;
            bytes[5] = 0;
            bytes[4] = 0;
            bytes[3] = 0;
            bytes[2] = 0;
            bytes[1] = 0;
            bytes[0] = -128;
        } else if (value >= -128L) {
            bytes = new byte[]{(byte)value};
        } else if (value >= -32768L) {
            bytes = new byte[2];
            bytes[1] = (byte)value;
            bytes[0] = (byte)(value >> 8);
        } else if (value >= -8388608L) {
            bytes = new byte[3];
            bytes[2] = (byte)value;
            bytes[1] = (byte)(value >> 8);
            bytes[0] = (byte)(value >> 16);
        } else if (value >= Integer.MIN_VALUE) {
            bytes = new byte[4];
            bytes[3] = (byte)value;
            bytes[2] = (byte)(value >> 8);
            bytes[1] = (byte)(value >> 16);
            bytes[0] = (byte)(value >> 24);
        } else if (value >= -549755813888L) {
            bytes = new byte[5];
            bytes[4] = (byte)value;
            bytes[3] = (byte)(value >> 8);
            bytes[2] = (byte)(value >> 16);
            bytes[1] = (byte)(value >> 24);
            bytes[0] = (byte)(value >> 32);
        } else if (value >= -140737488355328L) {
            bytes = new byte[6];
            bytes[5] = (byte)value;
            bytes[4] = (byte)(value >> 8);
            bytes[3] = (byte)(value >> 16);
            bytes[2] = (byte)(value >> 24);
            bytes[1] = (byte)(value >> 32);
            bytes[0] = (byte)(value >> 40);
        } else if (value >= -36028797018963968L) {
            bytes = new byte[7];
            bytes[6] = (byte)value;
            bytes[5] = (byte)(value >> 8);
            bytes[4] = (byte)(value >> 16);
            bytes[3] = (byte)(value >> 24);
            bytes[2] = (byte)(value >> 32);
            bytes[1] = (byte)(value >> 40);
            bytes[0] = (byte)(value >> 48);
        } else {
            bytes = new byte[8];
            bytes[7] = (byte)value;
            bytes[6] = (byte)(value >> 8);
            bytes[5] = (byte)(value >> 16);
            bytes[4] = (byte)(value >> 24);
            bytes[3] = (byte)(value >> 32);
            bytes[2] = (byte)(value >> 40);
            bytes[1] = (byte)(value >> 48);
            bytes[0] = (byte)(value >> 56);
        }
        return bytes;
    }

    public static void encode(ByteBuffer buffer, String string) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.OCTET_STRING.getValue());
            byte[] value = Asn1StringUtils.getBytesUtf8(string);
            buffer.put(TLV.getBytes(value.length));
            if (value.length != 0) {
                buffer.put(value);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, BitString bitString) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.BIT_STRING.getValue());
            byte[] bytes = bitString.getData();
            int length = bytes.length;
            buffer.put(TLV.getBytes(length));
            buffer.put(bytes);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, byte[] bytes) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.OCTET_STRING.getValue());
            if (bytes == null || bytes.length == 0) {
                buffer.put((byte)0);
            } else {
                buffer.put(TLV.getBytes(bytes.length));
                buffer.put(bytes);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, Oid oid) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.OCTET_STRING.getValue());
            buffer.put(TLV.getBytes(oid.getEncodedLength()));
            if (oid.getEncodedLength() != 0) {
                oid.writeBytesTo(buffer);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, int value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.INTEGER.getValue());
            buffer.put((byte)BerValue.getNbBytes(value));
            buffer.put(BerValue.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, long value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.INTEGER.getValue());
            buffer.put((byte)BerValue.getNbBytes(value));
            buffer.put(BerValue.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, byte tag, int value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(tag);
            buffer.put((byte)BerValue.getNbBytes(value));
            buffer.put(BerValue.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encodeEnumerated(ByteBuffer buffer, int value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.ENUMERATED.getValue());
            buffer.put(TLV.getBytes(BerValue.getNbBytes(value)));
            buffer.put(BerValue.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public static void encode(ByteBuffer buffer, boolean bool) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_00003_CANNOT_PUT_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            if (bool) {
                buffer.put(ENCODED_TRUE);
            } else {
                buffer.put(ENCODED_FALSE);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_00004_PDU_BUFFER_SIZE_TOO_SMALL, new Object[0]), boe);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DATA");
        if (this.data == null) {
            return "[]";
        }
        sb.append('[');
        sb.append(Asn1StringUtils.dumpBytes(this.data));
        sb.append(']');
        return sb.toString();
    }
}

